/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ezmorph.bean.MorphDynaBean;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.message.DefaultMuleMessageDTO;
import org.mule.module.json.JsonData;
import org.mule.module.json.util.JsonUtils;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.IOUtils;

public class JsonToObject
extends AbstractTransformer
implements DiscoverableTransformer {
    protected JsonConfig jsonConfig;
    protected Map dtoMappings;
    protected int weighting = 10;

    public JsonToObject() {
        this.registerSourceType(JSONObject.class);
        this.registerSourceType(String.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(byte[].class);
        this.setReturnClass(Object.class);
        this.dtoMappings = new HashMap(1);
        this.dtoMappings.put("payload", HashMap.class);
    }

    public int getPriorityWeighting() {
        return this.weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.getReturnClass().equals(Object.class)) {
            this.logger.warn((Object)"The return class is not set not type validation will be done");
        }
        if (this.getReturnClass().isArray()) {
            this.getJsonConfig().setEnclosedType(this.getReturnClass());
            this.getJsonConfig().setArrayMode(2);
        } else if (List.class.isAssignableFrom(this.getReturnClass())) {
            this.getJsonConfig().setEnclosedType(this.getReturnClass());
            this.getJsonConfig().setArrayMode(1);
        } else if (Set.class.isAssignableFrom(this.getReturnClass())) {
            this.getJsonConfig().setEnclosedType(this.getReturnClass());
            this.getJsonConfig().setArrayMode(2);
        }
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            Object returnValue = null;
            if (src instanceof byte[]) {
                src = new String((byte[])src, encoding);
            } else if (src instanceof InputStream) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)((InputStream)src), (OutputStream)baos);
                src = baos.toString();
            }
            if (src instanceof String) {
                if (this.getReturnClass().equals(JsonData.class)) {
                    this.getJsonConfig().setEnclosedType(this.getReturnClass());
                    JSON json = JSONSerializer.toJSON((Object)src.toString(), (JsonConfig)this.getJsonConfig());
                    if (json instanceof JSONArray) {
                        this.getJsonConfig().setEnclosedType(List.class);
                        this.getJsonConfig().setArrayMode(1);
                        List list = (List)JSONArray.toCollection((JSONArray)((JSONArray)json), (JsonConfig)this.getJsonConfig());
                        returnValue = new JsonData(list);
                    } else {
                        returnValue = JSONObject.toBean((JSONObject)((JSONObject)json), (JsonConfig)this.getJsonConfig());
                        returnValue = new JsonData((MorphDynaBean)returnValue);
                    }
                } else {
                    returnValue = JsonUtils.convertJsonToBean((String)src, this.getJsonConfig(), this.getReturnClass(), this.getReturnClass().equals(DefaultMuleMessageDTO.class) ? this.dtoMappings : null);
                }
            } else if (src instanceof JSONObject) {
                returnValue = JSONObject.toBean((JSONObject)((JSONObject)src), (Class)this.getReturnClass(), new HashMap());
            }
            Object object = returnValue;
            return object;
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.transformFailed((String)"json", (String)this.getReturnClass().getName()), (Transformer)this, (Throwable)e);
        }
        finally {
            if (src instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)((InputStream)src));
            }
        }
    }

    public JsonConfig getJsonConfig() {
        if (this.jsonConfig == null) {
            this.setJsonConfig(new JsonConfig());
        }
        return this.jsonConfig;
    }

    public void setJsonConfig(JsonConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
    }
}

