/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.util.ArrayList;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.module.json.util.JsonUtils;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.util.StringUtils;

public class ObjectToJson
extends AbstractMessageAwareTransformer {
    protected final transient Log logger = LogFactory.getLog(ObjectToJson.class);
    protected JsonConfig jsonConfig;
    protected String excludeProperties;
    protected String includeProperties;
    protected Class sourceClass;
    private boolean handleException = false;

    public ObjectToJson() {
        this.registerSourceType(Object.class);
        this.setReturnClass(String.class);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.getReturnClass().equals(Object.class)) {
            this.logger.warn((Object)"The return class is not set not type validation will be done");
        }
        if (this.excludeProperties != null) {
            this.getJsonConfig().setExcludes(StringUtils.splitAndTrim((String)this.excludeProperties, (String)","));
        }
        if (this.includeProperties != null) {
            this.getJsonConfig().setJsonPropertyFilter((PropertyFilter)new IncludePropertiesFilter(StringUtils.splitAndTrim((String)this.includeProperties, (String)",")));
        }
        if (this.getSourceClass() != null) {
            this.sourceTypes.clear();
            this.registerSourceType(this.getSourceClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object transform(MuleMessage message, String encoding) throws TransformerException {
        String returnValue;
        Object src = message.getPayload();
        if (message.getExceptionPayload() != null && this.isHandleException()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Found exception with null payload");
            }
            src = this.getException(message.getExceptionPayload().getException());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Converting payload " + src + " to " + String.class));
        }
        Class et = this.getJsonConfig().getEnclosedType();
        try {
            if (et == null) {
                this.getJsonConfig().setEnclosedType(src.getClass());
            }
            returnValue = JsonUtils.convertJavaObjectToJson(src, this.getJsonConfig());
        }
        finally {
            if (et == null) {
                this.getJsonConfig().setEnclosedType(null);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Successfully converted to value: " + returnValue));
        }
        return returnValue;
    }

    private Exception getException(Throwable t) {
        Exception returnValue = null;
        ArrayList<Throwable> causeStack = new ArrayList<Throwable>();
        for (Throwable tempCause = t; tempCause != null; tempCause = tempCause.getCause()) {
            causeStack.add(tempCause);
        }
        for (int i = causeStack.size() - 1; i >= 0; --i) {
            Throwable tempCause = (Throwable)causeStack.get(i);
            if (i == causeStack.size()) {
                returnValue = new Exception(tempCause.getMessage());
                returnValue.setStackTrace(tempCause.getStackTrace());
                continue;
            }
            returnValue = new Exception(tempCause.getMessage(), returnValue);
            returnValue.setStackTrace(tempCause.getStackTrace());
        }
        return returnValue;
    }

    public boolean isHandleException() {
        return this.handleException;
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    public JsonConfig getJsonConfig() {
        if (this.jsonConfig == null) {
            this.setJsonConfig(new JsonConfig());
        }
        return this.jsonConfig;
    }

    public void setJsonConfig(JsonConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
    }

    public String getExcludeProperties() {
        return this.excludeProperties;
    }

    public void setExcludeProperties(String excludeProperties) {
        this.excludeProperties = excludeProperties;
    }

    public String getIncludeProperties() {
        return this.includeProperties;
    }

    public void setIncludeProperties(String includeProperties) {
        this.includeProperties = includeProperties;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(Class sourceClass) {
        this.sourceClass = sourceClass;
    }

    private class IncludePropertiesFilter
    implements PropertyFilter {
        private String[] includedProperties;

        private IncludePropertiesFilter(String[] includedProperties) {
            this.includedProperties = includedProperties;
        }

        public boolean apply(Object source, String name, Object value) {
            for (int i = 0; i < this.includedProperties.length; ++i) {
                if (!this.includedProperties[i].equals(name)) continue;
                return false;
            }
            return true;
        }
    }
}

