/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.grizzly;

import com.ning.http.client.providers.grizzly.TransportCustomizer;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;

public class IOStrategyTransportCustomizer
implements TransportCustomizer {
    private static final String REQUESTER_WORKER_THREAD_NAME_SUFFIX = ".worker";
    private final String threadNamePrefix;
    private Integer maxWorkerPoolSize;
    private Integer workerCoreSize;
    private Integer maxKernelPoolSize;
    private Integer kernelCoreSize;
    private Integer selectorRunnerCoreSize;

    public IOStrategyTransportCustomizer(String threadNamePrefix, Integer maxWorkerPoolSize, Integer workerCoreSize, Integer maxKernelPoolSize, Integer kernelCoreSize, Integer selectorRunnerCoreSize) {
        this.threadNamePrefix = threadNamePrefix;
        this.maxWorkerPoolSize = maxWorkerPoolSize;
        this.workerCoreSize = workerCoreSize;
        this.maxKernelPoolSize = maxKernelPoolSize;
        this.kernelCoreSize = kernelCoreSize;
        this.selectorRunnerCoreSize = selectorRunnerCoreSize;
    }

    public void customize(TCPNIOTransport transport, FilterChainBuilder filterChainBuilder) {
        transport.setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
        transport.setWorkerThreadPoolConfig(WorkerThreadIOStrategy.getInstance().createDefaultWorkerPoolConfig((Transport)transport));
        this.customizePoolSize(transport);
        transport.getKernelThreadPoolConfig().setPoolName(this.threadNamePrefix);
        transport.getWorkerThreadPoolConfig().setPoolName(this.threadNamePrefix + REQUESTER_WORKER_THREAD_NAME_SUFFIX);
    }

    private void customizePoolSize(TCPNIOTransport transport) {
        if (this.maxKernelPoolSize != null) {
            transport.getKernelThreadPoolConfig().setMaxPoolSize(this.maxKernelPoolSize.intValue());
        }
        if (this.kernelCoreSize != null) {
            transport.getKernelThreadPoolConfig().setCorePoolSize(this.kernelCoreSize.intValue());
        }
        if (this.maxWorkerPoolSize != null) {
            transport.getWorkerThreadPoolConfig().setMaxPoolSize(this.maxWorkerPoolSize.intValue());
        }
        if (this.workerCoreSize != null) {
            transport.getWorkerThreadPoolConfig().setCorePoolSize(this.workerCoreSize.intValue());
        }
        if (this.selectorRunnerCoreSize != null) {
            transport.setSelectorRunnersCount(this.selectorRunnerCoreSize.intValue());
        }
    }
}

