/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.domain.request;

import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.mule.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnection {
    private static final Logger logger = LoggerFactory.getLogger(ClientConnection.class);
    private final SSLSession sslSession;
    private final InetSocketAddress remoteHostAddress;

    public ClientConnection(InetSocketAddress remoteHostAddress) {
        Preconditions.checkArgument((remoteHostAddress != null ? 1 : 0) != 0, (String)"remoteHostAddress cannot be null.");
        this.remoteHostAddress = remoteHostAddress;
        this.sslSession = null;
    }

    public ClientConnection(SSLSession sslSession, InetSocketAddress remoteHostAddress) {
        Preconditions.checkArgument((sslSession != null ? 1 : 0) != 0, (String)"sslSession cannot be null.");
        Preconditions.checkArgument((remoteHostAddress != null ? 1 : 0) != 0, (String)"remoteHostAddress cannot be null.");
        this.sslSession = sslSession;
        this.remoteHostAddress = remoteHostAddress;
    }

    public InetSocketAddress getRemoteHostAddress() {
        return this.remoteHostAddress;
    }

    public Certificate getClientCertificate() {
        block3: {
            try {
                Certificate[] peerCertificates;
                if (this.getSslSession() != null && (peerCertificates = this.getSslSession().getPeerCertificates()).length > 0) {
                    return peerCertificates[0];
                }
            }
            catch (SSLPeerUnverifiedException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Failure getting peer certificates", (Throwable)e);
            }
        }
        return null;
    }

    public SSLSession getSslSession() {
        return this.sslSession;
    }
}

