/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.domain.MultipartHttpEntity;
import org.mule.module.http.internal.multipart.HttpMimeMultipart;
import org.mule.module.http.internal.multipart.HttpPart;
import org.mule.util.IOUtils;

public class HttpMultipartEncoder {
    private static final String FORM_DATA = "form-data";
    private static final String RELATED = "related";
    private static final String TYPE_PARAMETER = "type";
    private static final String START_PARAMETER = "start";
    public static final String MANDATORY_TYPE_ERROR_MESSAGE = "Type parameter is not present in multipart/related content type, but it is mandatory.";
    public static final String AMBIGUOUS_TYPE_ERROR_MESSAGE = "Type parameter and root body part content type must be the same.";

    private HttpMultipartEncoder() {
    }

    public static MimeMultipart createContent(MultipartHttpEntity body, String contentType) {
        String contentTypeSubType = HttpParser.getContentTypeSubType(contentType);
        String typeParameter = HttpParser.getContentTypeParameter(contentType, TYPE_PARAMETER);
        if (contentTypeSubType.equals(RELATED) && typeParameter == null) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)MANDATORY_TYPE_ERROR_MESSAGE));
        }
        HttpMimeMultipart mimeMultipartContent = new HttpMimeMultipart(contentType, contentTypeSubType);
        Collection<HttpPart> parts = body.getParts();
        for (HttpPart part : parts) {
            InternetHeaders internetHeaders = new InternetHeaders();
            for (String headerName : part.getHeaderNames()) {
                Collection<String> headerValues = part.getHeaders(headerName);
                for (String headerValue : headerValues) {
                    internetHeaders.addHeader(headerName, headerValue);
                }
            }
            if (internetHeaders.getHeader("Content-Disposition") == null && contentTypeSubType.equals(FORM_DATA)) {
                internetHeaders.addHeader("Content-Disposition", HttpMultipartEncoder.getContentDisposition(part));
            }
            if (contentTypeSubType.equals(RELATED) && part.getName() != null) {
                internetHeaders.addHeader("Content-Id", part.getName());
            }
            if (internetHeaders.getHeader("Content-Type") == null && part.getContentType() != null) {
                internetHeaders.addHeader("Content-Type", part.getContentType());
            }
            try {
                byte[] partContent = IOUtils.toByteArray((InputStream)part.getInputStream());
                String rootContentId = HttpParser.getContentTypeParameter(contentType, START_PARAMETER);
                if (contentTypeSubType.equals(RELATED) && part.getName() != null && part.getName().equals(rootContentId)) {
                    mimeMultipartContent.addBodyPart((BodyPart)new MimeBodyPart(internetHeaders, partContent), 0);
                    continue;
                }
                mimeMultipartContent.addBodyPart((BodyPart)new MimeBodyPart(internetHeaders, partContent));
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        try {
            String rootBodyPartContentType;
            if (contentTypeSubType.equals(RELATED) && mimeMultipartContent.getCount() > 0 && (rootBodyPartContentType = mimeMultipartContent.getBodyPart(0).getContentType()) != null && !rootBodyPartContentType.equals(typeParameter)) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)AMBIGUOUS_TYPE_ERROR_MESSAGE));
            }
        }
        catch (MessagingException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return mimeMultipartContent;
    }

    private static String getContentDisposition(HttpPart part) {
        StringBuilder builder = new StringBuilder();
        builder.append(FORM_DATA);
        builder.append("; name=\"");
        builder.append(part.getName());
        builder.append("\"");
        if (part.getFileName() != null) {
            builder.append("; filename=\"");
            builder.append(part.getFileName());
            builder.append("\"");
        }
        return builder.toString();
    }

    public static byte[] createMultipartContent(MultipartHttpEntity multipartEntity, String contentType) throws IOException, MessagingException {
        MimeMultipart mimeMultipartContent = HttpMultipartEncoder.createContent(multipartEntity, contentType);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        mimeMultipartContent.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

