/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.strategies.AbstractIOStrategy;
import org.mule.module.http.internal.listener.ServerAddress;
import org.mule.module.http.internal.listener.grizzly.ExecutorProvider;

public class ExecutorPerServerAddressIOStrategy
extends AbstractIOStrategy {
    protected static final String EXECUTOR_REJECTED_ATTRIBUTE = "__executor_rejected__";
    private static final EnumSet<IOEvent> WORKER_THREAD_EVENT_SET = EnumSet.of(IOEvent.READ, IOEvent.CLOSED);
    private static final Logger logger = Grizzly.logger(ExecutorPerServerAddressIOStrategy.class);
    private final ExecutorProvider executorProvider;

    public ExecutorPerServerAddressIOStrategy(ExecutorProvider executorProvider) {
        this.executorProvider = executorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        IOEventLifeCycleListener listener;
        boolean isReadOrWriteEvent = ExecutorPerServerAddressIOStrategy.isReadWrite((IOEvent)ioEvent);
        if (isReadOrWriteEvent) {
            if (isIoEventEnabled) {
                connection.disableIOEvent(ioEvent);
            }
            listener = ENABLE_INTEREST_LIFECYCLE_LISTENER;
        } else {
            listener = null;
        }
        Executor threadPool = this.getThreadPoolFor(connection, ioEvent);
        if (threadPool != null) {
            try {
                threadPool.execute(new WorkerThreadRunnable(connection, ioEvent, listener));
            }
            catch (RejectedExecutionException e) {
                try {
                    connection.getAttributes().setAttribute(EXECUTOR_REJECTED_ATTRIBUTE, (Object)true);
                    ExecutorPerServerAddressIOStrategy.run0(connection, ioEvent, listener);
                }
                finally {
                    connection.getAttributes().removeAttribute(EXECUTOR_REJECTED_ATTRIBUTE);
                }
            }
        } else {
            ExecutorPerServerAddressIOStrategy.run0(connection, ioEvent, listener);
        }
        return true;
    }

    public Executor getThreadPoolFor(Connection connection, IOEvent ioEvent) {
        if (WORKER_THREAD_EVENT_SET.contains(ioEvent)) {
            String ip = ((InetSocketAddress)connection.getLocalAddress()).getAddress().getHostAddress();
            int port = ((InetSocketAddress)connection.getLocalAddress()).getPort();
            return this.executorProvider.getExecutor(new ServerAddress(ip, port));
        }
        return null;
    }

    private static void run0(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
        ExecutorPerServerAddressIOStrategy.fireIOEvent((Connection)connection, (IOEvent)ioEvent, (IOEventLifeCycleListener)lifeCycleListener, (Logger)logger);
    }

    private static final class WorkerThreadRunnable
    implements Runnable {
        final Connection connection;
        final IOEvent ioEvent;
        final IOEventLifeCycleListener lifeCycleListener;

        private WorkerThreadRunnable(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
            this.connection = connection;
            this.ioEvent = ioEvent;
            this.lifeCycleListener = lifeCycleListener;
        }

        @Override
        public void run() {
            ExecutorPerServerAddressIOStrategy.run0(this.connection, this.ioEvent, this.lifeCycleListener);
        }
    }
}

