/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import java.io.IOException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLConnectionContext;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.mule.module.http.api.HttpConstants;

public class MuleSslFilter
extends SSLFilter {
    public static final String SSL_SESSION_ATTRIBUTE_KEY = "muleSslSession";

    public MuleSslFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator) {
        super(serverSSLEngineConfigurator, clientSSLEngineConfigurator);
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        ctx.getAttributes().setAttribute(HttpConstants.Protocols.HTTPS.getScheme(), (Object)true);
        NextAction nextAction = super.handleRead(ctx);
        ctx.getAttributes().setAttribute(SSL_SESSION_ATTRIBUTE_KEY, (Object)this.getSslSession(ctx));
        return nextAction;
    }

    private SSLSession getSslSession(FilterChainContext ctx) throws SSLPeerUnverifiedException {
        SSLConnectionContext sslConnectionContext = this.obtainSslConnectionContext(ctx.getConnection());
        if (sslConnectionContext == null) {
            return null;
        }
        return sslConnectionContext.getSslEngine().getSession();
    }
}

