/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.List;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.api.HttpAuthentication;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.request.DefaultHttpRequesterConfig;
import org.mule.module.http.internal.request.HttpClient;
import org.mule.module.http.internal.request.HttpRequesterRequestBuilder;
import org.mule.module.http.internal.request.HttpResponseToMuleEvent;
import org.mule.module.http.internal.request.MuleEventToHttpRequest;
import org.mule.module.http.internal.request.ResponseValidator;
import org.mule.module.http.internal.request.SuccessStatusCodeValidator;
import org.mule.util.AttributeEvaluator;

public class DefaultHttpRequester
implements MessageProcessor,
Initialisable,
MuleContextAware {
    public static final List<String> DEFAULT_EMPTY_BODY_METHODS = Lists.newArrayList((Object[])new String[]{"GET", "HEAD", "OPTIONS"});
    public static final String DEFAULT_PAYLOAD_EXPRESSION = "#[payload]";
    public static final String DEFAULT_FOLLOW_REDIRECTS = "true";
    private DefaultHttpRequesterConfig requestConfig;
    private HttpRequesterRequestBuilder requestBuilder;
    private ResponseValidator responseValidator = new SuccessStatusCodeValidator("0..399");
    private AttributeEvaluator host;
    private AttributeEvaluator port;
    private AttributeEvaluator basePath;
    private AttributeEvaluator path;
    private AttributeEvaluator url;
    private AttributeEvaluator method = new AttributeEvaluator("GET");
    private AttributeEvaluator followRedirects;
    private AttributeEvaluator requestStreamingMode;
    private AttributeEvaluator sendBodyMode;
    private AttributeEvaluator parseResponse;
    private AttributeEvaluator responseTimeout;
    private String source;
    private String target;
    private MuleContext muleContext;
    private MuleEventToHttpRequest muleEventToHttpRequest;
    private HttpResponseToMuleEvent httpResponseToMuleEvent;

    public void initialise() throws InitialisationException {
        if (this.requestConfig == null) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"The config-ref attribute is required in the HTTP request element"), (Initialisable)this);
        }
        if (this.requestBuilder == null) {
            this.requestBuilder = new HttpRequesterRequestBuilder();
        }
        this.setEmptyAttributesFromConfig();
        this.validateRequiredProperties();
        this.basePath = new AttributeEvaluator(this.requestConfig.getBasePath());
        this.muleEventToHttpRequest = new MuleEventToHttpRequest(this, this.muleContext, this.requestStreamingMode, this.sendBodyMode);
        this.httpResponseToMuleEvent = new HttpResponseToMuleEvent(this, this.muleContext, this.parseResponse);
        this.initializeAttributeEvaluators(this.host, this.port, this.method, this.path, this.basePath, this.url, this.followRedirects, this.requestStreamingMode, this.sendBodyMode, this.parseResponse, this.responseTimeout);
    }

    private void setEmptyAttributesFromConfig() throws InitialisationException {
        if (this.host == null) {
            this.setHost(this.requestConfig.getHost());
        }
        if (this.port == null) {
            this.setPort(this.requestConfig.getPort());
        }
        if (this.followRedirects == null) {
            String requestFollowRedirect = this.requestConfig.getFollowRedirects();
            if (requestFollowRedirect == null) {
                requestFollowRedirect = DEFAULT_FOLLOW_REDIRECTS;
            }
            this.setFollowRedirects(requestFollowRedirect);
        }
        if (this.requestStreamingMode == null) {
            this.setRequestStreamingMode(this.requestConfig.getRequestStreamingMode());
        }
        if (this.sendBodyMode == null) {
            this.setSendBodyMode(this.requestConfig.getSendBodyMode());
        }
        if (this.parseResponse == null) {
            this.setParseResponse(this.requestConfig.getParseResponse());
        }
        if (this.responseTimeout == null && this.requestConfig.getResponseTimeout() != null) {
            this.setResponseTimeout(this.requestConfig.getResponseTimeout());
        }
    }

    private void validateRequiredProperties() throws InitialisationException {
        if (this.url == null) {
            if (this.host == null) {
                throw new InitialisationException(CoreMessages.createStaticMessage((String)"No host defined. Set the host attribute either in the request or request-config elements"), (Initialisable)this);
            }
            if (this.port == null) {
                throw new InitialisationException(CoreMessages.createStaticMessage((String)"No port defined. Set the host attribute either in the request or request-config elements"), (Initialisable)this);
            }
            if (this.path == null) {
                throw new InitialisationException(CoreMessages.createStaticMessage((String)"The path attribute is required in the HTTP request element"), (Initialisable)this);
            }
        }
    }

    private void initializeAttributeEvaluators(AttributeEvaluator ... attributeEvaluators) {
        for (AttributeEvaluator attributeEvaluator : attributeEvaluators) {
            if (attributeEvaluator == null) continue;
            attributeEvaluator.initialize(this.muleContext.getExpressionManager());
        }
    }

    public MuleEvent process(MuleEvent muleEvent) throws MuleException {
        return this.innerProcess(muleEvent, true);
    }

    private MuleEvent innerProcess(MuleEvent muleEvent, boolean checkRetry) throws MuleException {
        HttpResponse response;
        HttpRequestBuilder builder = this.muleEventToHttpRequest.create(muleEvent, this.method.resolveStringValue(muleEvent), this.resolveURI(muleEvent));
        HttpAuthentication authentication = this.requestConfig.getAuthentication();
        if (authentication != null) {
            authentication.authenticate(muleEvent, builder);
        }
        HttpClient httpClient = this.requestConfig.getHttpClient();
        try {
            response = httpClient.send(builder.build(), this.resolveResponseTimeout(muleEvent), this.followRedirects.resolveBooleanValue(muleEvent), authentication);
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.createStaticMessage((String)"Error sending HTTP request"), muleEvent, (Throwable)e);
        }
        this.httpResponseToMuleEvent.convert(muleEvent, response);
        if (checkRetry && authentication != null && authentication.shouldRetry(muleEvent)) {
            this.consumePayload(muleEvent);
            muleEvent = this.innerProcess(muleEvent, false);
        } else {
            this.responseValidator.validate(muleEvent);
        }
        return muleEvent;
    }

    private int resolveResponseTimeout(MuleEvent muleEvent) {
        if (this.responseTimeout == null) {
            return muleEvent.getTimeout();
        }
        return this.responseTimeout.resolveIntegerValue(muleEvent);
    }

    private String resolveURI(MuleEvent muleEvent) throws MessagingException {
        if (this.url != null) {
            return this.url.resolveStringValue(muleEvent);
        }
        String resolvedPath = this.replaceUriParams(this.buildPath(this.basePath.resolveStringValue(muleEvent), this.path.resolveStringValue(muleEvent)), muleEvent);
        resolvedPath = HttpParser.encodeSpaces(resolvedPath);
        return String.format("%s://%s:%s%s", this.requestConfig.getScheme(), this.host.resolveStringValue(muleEvent), this.port.resolveIntegerValue(muleEvent), resolvedPath);
    }

    private String replaceUriParams(String path, MuleEvent event) {
        if (this.requestBuilder == null) {
            return path;
        }
        return this.requestBuilder.replaceUriParams(path, event);
    }

    protected String buildPath(String basePath, String path) {
        String resolvedBasePath = basePath;
        String resolvedRequestPath = path;
        if (!resolvedBasePath.startsWith("/")) {
            resolvedBasePath = "/" + resolvedBasePath;
        }
        if (resolvedBasePath.endsWith("/") && resolvedRequestPath.startsWith("/")) {
            resolvedBasePath = resolvedBasePath.substring(0, resolvedBasePath.length() - 1);
        }
        if (!(resolvedBasePath.endsWith("/") || resolvedRequestPath.startsWith("/") || resolvedRequestPath.isEmpty())) {
            resolvedBasePath = resolvedBasePath + "/";
        }
        return resolvedBasePath + resolvedRequestPath;
    }

    private void consumePayload(MuleEvent event) {
        if (event.getMessage().getPayload() instanceof InputStream) {
            try {
                event.getMessage().getPayloadAsBytes();
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    public String getHost() {
        return this.host.getRawValue();
    }

    public void setHost(String host) {
        this.host = new AttributeEvaluator(host);
    }

    public String getPort() {
        return this.port.getRawValue();
    }

    public void setPort(String port) {
        this.port = new AttributeEvaluator(port);
    }

    public String getPath() {
        return this.path.getRawValue();
    }

    public void setPath(String path) {
        this.path = new AttributeEvaluator(path);
    }

    public String getUrl() {
        return this.url.getRawValue();
    }

    public void setUrl(String url) {
        this.url = new AttributeEvaluator(url);
    }

    public HttpRequesterRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public void setRequestBuilder(HttpRequesterRequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    public String getMethod() {
        return this.method.getRawValue();
    }

    public void setMethod(String method) {
        this.method = new AttributeEvaluator(method);
    }

    public DefaultHttpRequesterConfig getConfig() {
        return this.requestConfig;
    }

    public void setConfig(DefaultHttpRequesterConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    public void setFollowRedirects(String followsRedirects) {
        this.followRedirects = new AttributeEvaluator(followsRedirects);
    }

    public void setRequestStreamingMode(String requestStreamingMode) {
        this.requestStreamingMode = new AttributeEvaluator(requestStreamingMode);
    }

    public ResponseValidator getResponseValidator() {
        return this.responseValidator;
    }

    public void setResponseValidator(ResponseValidator responseValidator) {
        this.responseValidator = responseValidator;
    }

    public void setSendBodyMode(String sendBodyMode) {
        this.sendBodyMode = new AttributeEvaluator(sendBodyMode);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setParseResponse(String parseResponse) {
        this.parseResponse = new AttributeEvaluator(parseResponse);
    }

    public void setResponseTimeout(String responseTimeout) {
        this.responseTimeout = new AttributeEvaluator(responseTimeout);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

