/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.guice;

import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.registry.RegistrationException;
import org.mule.registry.AbstractRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceRegistry
extends AbstractRegistry {
    private Injector injector = null;

    public GuiceRegistry(MuleContext muleContext) {
        super("guice", muleContext);
    }

    GuiceRegistry(Injector injector, MuleContext muleContext) {
        this(muleContext);
        this.injector = injector;
    }

    protected void doInitialise() throws InitialisationException {
        try {
            this.getLifecycleManager().fireLifecycle("initialise");
        }
        catch (LifecycleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void doDispose() {
        try {
            this.getLifecycleManager().fireLifecycle("dispose");
        }
        catch (LifecycleException e) {
            this.logger.error((Object)("Failed to shut down Guice registry cleanly: " + this.getRegistryId()), (Throwable)e);
        }
    }

    public <T> T lookupObject(String key) {
        return null;
    }

    public <T> T get(String key) {
        return null;
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return null;
    }

    public <T> Collection<T> lookupObjects(Class<T> type) {
        try {
            List bindings = this.injector.findBindingsByType(TypeLiteral.get(type));
            if (bindings != null && bindings.size() > 0) {
                ArrayList<Object> list = new ArrayList<Object>(bindings.size());
                for (Binding binding : bindings) {
                    list.add(binding.getProvider().get());
                }
                return list;
            }
            return Collections.emptyList();
        }
        catch (ConfigurationException e) {
            return Collections.emptyList();
        }
    }

    public void registerObject(String key, Object value) throws RegistrationException {
        throw new UnsupportedOperationException("registerObject");
    }

    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        throw new UnsupportedOperationException("registerObject");
    }

    public void registerObjects(Map objects) throws RegistrationException {
        throw new UnsupportedOperationException("registerObjects");
    }

    public void unregisterObject(String key) throws RegistrationException {
        throw new UnsupportedOperationException("unregisterObject");
    }

    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        throw new UnsupportedOperationException("unregisterObject");
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRemote() {
        return false;
    }
}

