/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.agent.Agent;
import org.mule.api.config.ConfigurationException;
import org.mule.api.registry.Registry;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.guice.AbstractMuleGuiceModule;
import org.mule.module.guice.GuiceModuleFactory;
import org.mule.module.guice.GuiceRegistry;
import org.mule.util.ClassUtils;
import org.mule.util.ObjectNameHelper;
import org.mule.util.scan.ClasspathScanner;

public class GuiceConfigurationBuilder
extends AbstractConfigurationBuilder {
    private String basepath = "";
    private Module[] modules = null;
    private Stage stage;
    private ClassLoader classLoader;

    public GuiceConfigurationBuilder() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public GuiceConfigurationBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public GuiceConfigurationBuilder(String basepath) {
        this();
        this.basepath = basepath;
    }

    public GuiceConfigurationBuilder(String basepath, ClassLoader classLoader) {
        this.basepath = basepath;
        this.classLoader = classLoader;
    }

    public GuiceConfigurationBuilder(Module ... modules) {
        this.modules = modules;
    }

    public GuiceConfigurationBuilder(Stage stage, Module ... modules) {
        this.stage = stage;
        this.modules = modules;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        if (this.basepath != null && this.basepath.startsWith("/")) {
            this.basepath = this.basepath.substring(1);
        }
        if (this.modules == null) {
            ClasspathScanner scanner = new ClasspathScanner(this.classLoader, new String[]{this.basepath});
            Set classes = scanner.scanFor(Module.class);
            Set factories = scanner.scanFor(GuiceModuleFactory.class);
            classes.remove(AbstractMuleGuiceModule.class);
            if (classes.size() == 0 && factories.size() == 0) {
                try {
                    this.basepath = ((Object)((Object)this)).getClass().getClassLoader().getResources(this.basepath).toString();
                }
                catch (Exception e) {
                    this.basepath = this.basepath.equals("") ? "/" : this.basepath;
                }
                this.logger.warn((Object)new ConfigurationException(CoreMessages.createStaticMessage((String)("There are no Guice modules or module factories on the classpath under: " + this.basepath))));
                return;
            }
            this.modules = new Module[classes.size() + factories.size()];
            int i = 0;
            for (Class moduleClass : classes) {
                Module module = (Module)ClassUtils.instanciateClass((Class)moduleClass, (Object[])ClassUtils.NO_ARGS);
                this.modules[i++] = module;
            }
            for (Class factoryClass : factories) {
                GuiceModuleFactory factory = (GuiceModuleFactory)ClassUtils.instanciateClass((Class)factoryClass, (Object[])ClassUtils.NO_ARGS);
                this.modules[i++] = factory.createModule();
            }
        }
        for (int i = 0; i < this.modules.length; ++i) {
            Module module = this.modules[i];
            if (!(module instanceof AbstractMuleGuiceModule)) continue;
            ((AbstractMuleGuiceModule)module).setMuleContext(muleContext);
        }
        Injector injector = this.stage != null ? Guice.createInjector((Stage)this.stage, (Module[])this.modules) : Guice.createInjector((Module[])this.modules);
        GuiceRegistry registry = new GuiceRegistry(injector);
        muleContext.addRegistry(2L, (Registry)registry);
        for (Key key : injector.getBindings().keySet()) {
            if (Connector.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
                Connector c = (Connector)injector.getInstance(key);
                c.setName(new ObjectNameHelper(muleContext).getConnectorName(c));
                muleContext.getRegistry().registerConnector(c);
                continue;
            }
            if (Agent.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
                Agent a = (Agent)injector.getInstance(key);
                muleContext.getRegistry().registerAgent(a);
                continue;
            }
            if (!Transformer.class.isAssignableFrom(key.getTypeLiteral().getRawType())) continue;
            Transformer t = (Transformer)injector.getInstance(key);
            muleContext.getRegistry().registerTransformer(t);
        }
        registry.initialise();
    }
}

