/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.extension.introspection.Capable;
import org.mule.module.extension.internal.capability.metadata.ParameterGroupCapability;
import org.mule.module.extension.internal.introspection.ParameterGroup;
import org.mule.module.extension.internal.runtime.DefaultObjectBuilder;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.module.extension.internal.util.CapabilityUtils;
import org.mule.module.extension.internal.util.ValueSetter;
import org.springframework.util.ReflectionUtils;

public final class GroupValueSetter
implements ValueSetter {
    private final ParameterGroup group;
    private final List<ValueSetter> childSetters;

    public static List<ValueSetter> settersFor(Capable capable) {
        ImmutableList.Builder groupValueSetters = ImmutableList.builder();
        ParameterGroupCapability parameterGroupCapability = CapabilityUtils.getSingleCapability(capable, ParameterGroupCapability.class);
        if (parameterGroupCapability != null) {
            for (ParameterGroup group : parameterGroupCapability.getGroups()) {
                groupValueSetters.add((Object)new GroupValueSetter(group));
            }
        }
        return groupValueSetters.build();
    }

    public GroupValueSetter(ParameterGroup group) {
        this.group = group;
        this.childSetters = GroupValueSetter.settersFor(group);
    }

    @Override
    public void set(Object target, ResolverSetResult result) throws MuleException {
        DefaultObjectBuilder groupBuilder = new DefaultObjectBuilder(this.group.getType());
        for (Map.Entry<String, Field> parameter : this.group.getParameters().entrySet()) {
            groupBuilder.addPropertyResolver(parameter.getValue(), new StaticValueResolver<Object>(result.get(parameter.getKey())));
        }
        Object groupValue = groupBuilder.build((MuleEvent)VoidMuleEvent.getInstance());
        ReflectionUtils.setField((Field)this.group.getField(), (Object)target, groupValue);
        for (ValueSetter childSetter : this.childSetters) {
            childSetter.set(groupValue, result);
        }
    }
}

