/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.AttributeEvaluator;
import org.mule.util.ClassUtils;
import org.mule.util.Preconditions;

public class TypeSafeExpressionValueResolver<T>
implements ValueResolver<T> {
    private final org.mule.extension.introspection.DataType expectedType;
    private final AttributeEvaluator evaluator;
    private MuleContext muleContext;
    private EvaluatorDelegate delegate = new CaptureContextEvaluatorDelegate();

    public TypeSafeExpressionValueResolver(String expression, org.mule.extension.introspection.DataType expectedType) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)expression) ? 1 : 0) != 0, (String)"Expression cannot be blank or null");
        Preconditions.checkArgument((expectedType != null ? 1 : 0) != 0, (String)"expected type cannot be null");
        this.expectedType = expectedType;
        this.evaluator = new AttributeEvaluator(expression);
    }

    @Override
    public T resolve(MuleEvent event) throws MuleException {
        Object evaluated = this.delegate.resolveValue(event);
        return (T)(evaluated != null ? this.transform(evaluated, event) : null);
    }

    private T transform(T object, MuleEvent event) throws MuleException {
        Transformer transformer;
        if (ClassUtils.isInstance((Class)this.expectedType.getRawType(), object)) {
            return object;
        }
        Type expectedClass = this.expectedType.getRawType();
        if (expectedClass instanceof ParameterizedType) {
            expectedClass = ((ParameterizedType)expectedClass).getRawType();
        }
        DataType sourceDataType = DataTypeFactory.create(object.getClass());
        DataType targetDataType = DataTypeFactory.create((Class)expectedClass);
        try {
            transformer = this.muleContext.getRegistry().lookupTransformer(sourceDataType, targetDataType);
        }
        catch (TransformerException e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)String.format("Expression '%s' was expected to return a value of type '%s' but a '%s' was found instead and no suitable transformer could be located", this.evaluator.getRawValue(), this.expectedType.getRawType().getName(), object.getClass().getName())), event, (Throwable)e);
        }
        if (transformer instanceof MessageTransformer) {
            return (T)((MessageTransformer)transformer).transform(object, event);
        }
        return (T)transformer.transform(object);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    private class PassThroughEvaluatorDelegate
    implements EvaluatorDelegate {
        private PassThroughEvaluatorDelegate() {
        }

        @Override
        public Object resolveValue(MuleEvent event) {
            return TypeSafeExpressionValueResolver.this.evaluator.resolveValue(event);
        }
    }

    private class CaptureContextEvaluatorDelegate
    implements EvaluatorDelegate {
        private CaptureContextEvaluatorDelegate() {
        }

        @Override
        public synchronized Object resolveValue(MuleEvent event) {
            if (TypeSafeExpressionValueResolver.this.muleContext == null) {
                TypeSafeExpressionValueResolver.this.muleContext = event.getMuleContext();
                TypeSafeExpressionValueResolver.this.evaluator.initialize(TypeSafeExpressionValueResolver.this.muleContext.getExpressionManager());
                TypeSafeExpressionValueResolver.this.delegate = new PassThroughEvaluatorDelegate();
            }
            return TypeSafeExpressionValueResolver.this.delegate.resolveValue(event);
        }
    }

    private static interface EvaluatorDelegate {
        public Object resolveValue(MuleEvent var1);
    }
}

