/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.resolver;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.mule.extension.introspection.Parameter;
import org.mule.util.Preconditions;

public class ResolverSetResult {
    private final Map<Parameter, Object> evaluationResult;
    private final Map<String, Object> parameterToResult;
    private final int hashCode;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ResolverSetResult(Map<Parameter, Object> evaluationResult, int hashCode) {
        this.evaluationResult = evaluationResult;
        this.parameterToResult = new HashMap<String, Object>(evaluationResult.size());
        for (Map.Entry<Parameter, Object> entry : evaluationResult.entrySet()) {
            this.parameterToResult.put(entry.getKey().getName(), entry.getValue());
        }
        this.hashCode = hashCode;
    }

    public Object get(Parameter parameter) {
        if (!this.evaluationResult.containsKey(parameter)) {
            throw new NoSuchElementException("This result contains no information for the parameter: " + parameter.getName());
        }
        return this.evaluationResult.get(parameter);
    }

    public Object get(String parameterName) {
        if (!this.parameterToResult.containsKey(parameterName)) {
            throw new NoSuchElementException("This result contains no information for the parameter: " + parameterName);
        }
        return this.parameterToResult.get(parameterName);
    }

    public Map<Parameter, Object> asMap() {
        return Collections.unmodifiableMap(this.evaluationResult);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResolverSetResult) {
            ResolverSetResult other = (ResolverSetResult)obj;
            for (Map.Entry<Parameter, Object> entry : this.evaluationResult.entrySet()) {
                Object otherValue = other.get(entry.getKey());
                if (Objects.equal((Object)entry.getValue(), (Object)otherValue)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static final class Builder {
        private int hashCode = 1;
        private Map<Parameter, Object> values = new LinkedHashMap<Parameter, Object>();

        private Builder() {
        }

        public Builder add(Parameter parameter, Object value) {
            Preconditions.checkArgument((parameter != null ? 1 : 0) != 0, (String)"parameter cannot be null");
            this.values.put(parameter, value);
            this.hashCode = 31 * this.hashCode + (value == null ? 0 : value.hashCode());
            return this;
        }

        public ResolverSetResult build() {
            return new ResolverSetResult(Collections.unmodifiableMap(this.values), this.hashCode);
        }
    }
}

