/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import java.lang.reflect.Method;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.introspection.declaration.fluent.OperationExecutorFactory;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.runtime.ReflectiveMethodOperationExecutor;
import org.mule.module.extension.internal.runtime.ReturnDelegate;
import org.mule.module.extension.internal.runtime.ValueReturnDelegate;
import org.mule.module.extension.internal.runtime.VoidReturnDelegate;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.util.Preconditions;

public final class ReflectiveOperationExecutorFactory<T>
implements OperationExecutorFactory {
    private final Class<T> implementationClass;
    private final Method operationMethod;
    private final ReturnDelegate returnDelegate;

    public ReflectiveOperationExecutorFactory(Class<T> implementationClass, Method operationMethod) {
        Preconditions.checkArgument((implementationClass != null ? 1 : 0) != 0, (String)"implementationClass cannot be null");
        Preconditions.checkArgument((operationMethod != null ? 1 : 0) != 0, (String)"operationMethod cannot be null");
        this.implementationClass = implementationClass;
        this.operationMethod = operationMethod;
        this.returnDelegate = IntrospectionUtils.isVoid(operationMethod) ? VoidReturnDelegate.INSTANCE : ValueReturnDelegate.INSTANCE;
    }

    public OperationExecutor createExecutor() {
        T delegate;
        try {
            delegate = this.implementationClass.newInstance();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)("Could not create instance of operation class " + this.implementationClass.getName())), (Throwable)e);
        }
        return new ReflectiveMethodOperationExecutor(this.operationMethod, delegate, this.returnDelegate);
    }
}

