/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.mule.api.MuleRuntimeException;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.internal.runtime.ConfigurationObjectBuilder;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.util.MuleExtensionUtils;

public final class DynamicConfigurationInstanceProvider<T>
implements ConfigurationInstanceProvider<T> {
    private final ConfigurationObjectBuilder configurationObjectBuilder;
    private final ResolverSet resolverSet;
    private LoadingCache<ResolverSetResult, T> cache;

    public DynamicConfigurationInstanceProvider(ConfigurationObjectBuilder configurationObjectBuilder, ResolverSet resolverSet) {
        this.configurationObjectBuilder = configurationObjectBuilder;
        this.resolverSet = resolverSet;
        this.buildCache();
    }

    private void buildCache() {
        this.cache = CacheBuilder.newBuilder().build(new CacheLoader<ResolverSetResult, T>(){

            public T load(ResolverSetResult resolverSetResult) throws Exception {
                return DynamicConfigurationInstanceProvider.this.configurationObjectBuilder.build(resolverSetResult);
            }
        });
    }

    public T get(OperationContext operationContext) {
        try {
            ResolverSetResult result = this.resolverSet.resolve(MuleExtensionUtils.asOperationContextAdapter(operationContext).getEvent());
            return (T)this.cache.getUnchecked((Object)result);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

