/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import java.util.Collection;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.introspection.declaration.fluent.DeclarationDescriptor;
import org.mule.module.extension.CapabilityExtractor;
import org.mule.module.extension.internal.introspection.CapabilitiesResolver;
import org.mule.util.Preconditions;

final class DefaultCapabilitiesResolver
implements CapabilitiesResolver {
    private final ServiceRegistry serviceRegistry;

    public DefaultCapabilitiesResolver(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void resolveCapabilities(DeclarationDescriptor declaration, Class<?> capableType) {
        Preconditions.checkArgument((declaration != null ? 1 : 0) != 0, (String)"declaration descriptor cannot be null");
        Preconditions.checkArgument((capableType != null ? 1 : 0) != 0, (String)"capable type cannot be null");
        for (CapabilityExtractor extractor : this.getExtractors()) {
            Object capability = extractor.extractCapability(declaration, capableType);
            if (capability == null) continue;
            declaration.withCapability(capability);
        }
    }

    private Collection<CapabilityExtractor> getExtractors() {
        return this.serviceRegistry.lookupProviders(CapabilityExtractor.class, this.getClass().getClassLoader());
    }
}

