/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import com.google.common.util.concurrent.Futures;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang.ArrayUtils;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.extension.annotations.ParameterGroup;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.internal.introspection.MuleExtensionAnnotationParser;
import org.mule.module.extension.internal.runtime.DelegatingOperationExecutor;
import org.mule.module.extension.internal.runtime.ReturnDelegate;
import org.mule.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.module.extension.internal.runtime.resolver.ByParameterNameArgumentResolver;
import org.mule.module.extension.internal.runtime.resolver.EventArgumentResolver;
import org.mule.module.extension.internal.runtime.resolver.MessageArgumentResolver;
import org.mule.module.extension.internal.runtime.resolver.ParameterGroupArgumentResolver;
import org.springframework.util.ReflectionUtils;

final class ReflectiveMethodOperationExecutor<D>
implements DelegatingOperationExecutor<D> {
    private static final ArgumentResolverDelegate NO_ARGS_DELEGATE = new NoArgumentsResolverDelegate();
    private final Method operationMethod;
    private final D executorDelegate;
    private final ReturnDelegate returnDelegate;
    private ArgumentResolverDelegate argumentResolverDelegate;

    ReflectiveMethodOperationExecutor(Method operationMethod, D executorDelegate, ReturnDelegate returnDelegate) {
        this.operationMethod = operationMethod;
        this.executorDelegate = executorDelegate;
        this.returnDelegate = returnDelegate;
        this.argumentResolverDelegate = ArrayUtils.isEmpty((Object[])operationMethod.getParameterTypes()) ? NO_ARGS_DELEGATE : new MethodArgumentResolverDelegate(operationMethod);
    }

    public Future<Object> execute(OperationContext operationContext) throws Exception {
        Object result = ReflectionUtils.invokeMethod((Method)this.operationMethod, this.executorDelegate, (Object[])this.getParameterValues(operationContext));
        return Futures.immediateFuture((Object)this.returnDelegate.asReturnValue(result, operationContext));
    }

    @Override
    public D getExecutorDelegate() {
        return this.executorDelegate;
    }

    private Object[] getParameterValues(OperationContext operationContext) {
        return this.argumentResolverDelegate.resolve(operationContext);
    }

    private class MethodArgumentResolverDelegate
    implements ArgumentResolverDelegate {
        private final Method method;
        private ArgumentResolver<? extends Object>[] argumentResolvers;

        public MethodArgumentResolverDelegate(Method method) {
            this.method = method;
            this.initArgumentResolvers();
        }

        private void initArgumentResolvers() {
            Object[] parameterTypes = this.method.getParameterTypes();
            if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
                this.argumentResolvers = new ArgumentResolver[0];
            }
            this.argumentResolvers = new ArgumentResolver[parameterTypes.length];
            Annotation[][] parameterAnnotations = ReflectiveMethodOperationExecutor.this.operationMethod.getParameterAnnotations();
            String[] paramNames = MuleExtensionAnnotationParser.getParamNames(ReflectiveMethodOperationExecutor.this.operationMethod);
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object parameterType = parameterTypes[i];
                Map<Class<? extends Annotation>, Annotation> annotations = MuleExtensionAnnotationParser.toMap(parameterAnnotations[i]);
                this.argumentResolvers[i] = MuleEvent.class.isAssignableFrom((Class<?>)parameterType) ? new EventArgumentResolver() : (MuleMessage.class.isAssignableFrom((Class<?>)parameterType) ? new MessageArgumentResolver() : (annotations.get(ParameterGroup.class) != null ? new ParameterGroupArgumentResolver<Object>((Class<? extends Object>)parameterType) : new ByParameterNameArgumentResolver<Object>(paramNames[i])));
            }
        }

        @Override
        public Object[] resolve(OperationContext operationContext) {
            Object[] parameterValues = new Object[this.argumentResolvers.length];
            int i = 0;
            for (ArgumentResolver<? extends Object> argumentResolver : this.argumentResolvers) {
                parameterValues[i++] = argumentResolver.resolve(operationContext);
            }
            return parameterValues;
        }
    }

    private static class NoArgumentsResolverDelegate
    implements ArgumentResolverDelegate {
        private static Object[] EMPTY = new Object[0];

        private NoArgumentsResolverDelegate() {
        }

        @Override
        public Object[] resolve(OperationContext operationContext) {
            return EMPTY;
        }
    }

    private static interface ArgumentResolverDelegate {
        public Object[] resolve(OperationContext var1);
    }
}

