/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.exception.NoSuchConfigurationException;
import org.mule.extension.exception.NoSuchOperationException;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.module.extension.internal.introspection.AbstractImmutableCapableDescribed;
import org.mule.module.extension.internal.util.MuleExtensionUtils;
import org.mule.util.Preconditions;

final class ImmutableExtension
extends AbstractImmutableCapableDescribed
implements Extension {
    private final String version;
    private final Map<String, Configuration> configurations;
    private final Map<String, Operation> operations;

    protected ImmutableExtension(String name, String description, String version, List<Configuration> configurations, List<Operation> operations, Set<Object> capabilities) {
        super(name, description, capabilities);
        Preconditions.checkArgument((!name.contains(" ") ? 1 : 0) != 0, (String)"Extension name cannot contain spaces");
        MuleExtensionUtils.checkNullOrRepeatedNames(configurations, "configurations");
        MuleExtensionUtils.checkNullOrRepeatedNames(operations, "operations");
        MuleExtensionUtils.checkNamesClashes(configurations, operations);
        this.configurations = MuleExtensionUtils.toMap(configurations);
        this.operations = MuleExtensionUtils.toMap(operations);
        Preconditions.checkArgument((!StringUtils.isBlank((String)version) ? 1 : 0) != 0, (String)"version cannot be blank");
        this.version = version;
    }

    public List<Configuration> getConfigurations() {
        return ImmutableList.copyOf(this.configurations.values());
    }

    public Configuration getConfiguration(String name) throws NoSuchConfigurationException {
        Configuration configuration = this.configurations.get(name);
        if (configuration == null) {
            throw new NoSuchConfigurationException((Extension)this, name);
        }
        return configuration;
    }

    public List<Operation> getOperations() {
        return ImmutableList.copyOf(this.operations.values());
    }

    public String getVersion() {
        return this.version;
    }

    public Operation getOperation(String name) throws NoSuchOperationException {
        Operation operation = this.operations.get(name);
        if (operation == null) {
            throw new NoSuchOperationException((Extension)this, name);
        }
        return operation;
    }
}

