/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml.schema;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.apache.commons.collections.Predicate;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.annotations.Configuration;
import org.mule.extension.annotations.Parameter;
import org.mule.extension.annotations.ParameterGroup;
import org.mule.extension.introspection.declaration.fluent.ConfigurationDeclaration;
import org.mule.extension.introspection.declaration.fluent.Declaration;
import org.mule.extension.introspection.declaration.fluent.OperationDeclaration;
import org.mule.extension.introspection.declaration.fluent.ParameterDeclaration;
import org.mule.module.extension.internal.capability.xml.schema.AnnotationProcessorUtils;
import org.mule.module.extension.internal.capability.xml.schema.MethodDocumentation;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.util.CollectionUtils;

final class SchemaDocumenter {
    private ProcessingEnvironment processingEnv;

    SchemaDocumenter(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    void document(Declaration declaration, TypeElement extensionElement, RoundEnvironment roundEnvironment) {
        declaration.setDescription(AnnotationProcessorUtils.getJavaDocSummary(this.processingEnv, extensionElement));
        this.documentConfigurations(declaration, extensionElement, roundEnvironment);
        this.documentOperations(declaration, roundEnvironment);
    }

    private void documentOperations(Declaration declaration, RoundEnvironment roundEnvironment) {
        Map<String, ExecutableElement> methods = AnnotationProcessorUtils.getOperationMethods(roundEnvironment);
        try {
            for (OperationDeclaration operation : declaration.getOperations()) {
                ExecutableElement method = methods.get(operation.getName());
                if (method == null) continue;
                MethodDocumentation documentation = AnnotationProcessorUtils.getMethodDocumentation(this.processingEnv, method);
                operation.setDescription(documentation.getSummary());
                this.documentOperationParameters(operation, documentation);
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Exception found while trying to document XSD schema"), (Throwable)e);
        }
    }

    private void documentOperationParameters(OperationDeclaration operation, MethodDocumentation documentation) {
        for (ParameterDeclaration parameter : operation.getParameters()) {
            String description = documentation.getParameters().get(parameter.getName());
            if (description == null) continue;
            parameter.setDescription(description);
        }
    }

    private void documentConfigurations(Declaration declaration, TypeElement extensionElement, RoundEnvironment roundEnvironment) {
        if (declaration.getConfigurations().size() > 1) {
            for (TypeElement configurationElement : AnnotationProcessorUtils.getTypeElementsAnnotatedWith(Configuration.class, roundEnvironment)) {
                ConfigurationDeclaration configurationDeclaration = this.findMatchingConfiguration(declaration, configurationElement);
                this.documentConfigurationParameters(configurationDeclaration.getParameters(), configurationElement);
            }
        } else {
            this.documentConfigurationParameters(((ConfigurationDeclaration)declaration.getConfigurations().get(0)).getParameters(), extensionElement);
        }
    }

    private void documentConfigurationParameters(Collection<ParameterDeclaration> parameters, TypeElement element) {
        Map<String, VariableElement> variableElements = AnnotationProcessorUtils.getFieldsAnnotatedWith(element, Parameter.class);
        TypeElement traversingElement = element;
        while (traversingElement != null && !Object.class.getName().equals(traversingElement.getQualifiedName().toString())) {
            Class declaringClass = AnnotationProcessorUtils.classFor(traversingElement, this.processingEnv);
            for (ParameterDeclaration parameter : parameters) {
                Field field = IntrospectionUtils.getField(declaringClass, (ParameterDeclaration)parameter);
                if (field == null || !variableElements.containsKey(field.getName())) continue;
                parameter.setDescription(AnnotationProcessorUtils.getJavaDocSummary(this.processingEnv, variableElements.get(field.getName())));
            }
            traversingElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(traversingElement.getSuperclass());
        }
        for (VariableElement variableElement : AnnotationProcessorUtils.getFieldsAnnotatedWith(element, ParameterGroup.class).values()) {
            TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(variableElement.asType());
            this.documentConfigurationParameters(parameters, typeElement);
        }
    }

    private ConfigurationDeclaration findMatchingConfiguration(Declaration declaration, final TypeElement configurationElement) {
        return (ConfigurationDeclaration)CollectionUtils.find((Collection)declaration.getConfigurations(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Configuration configuration = configurationElement.getAnnotation(Configuration.class);
                ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)object;
                return configurationDeclaration.getName().equals(configuration.name());
            }
        });
    }
}

