/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml;

import org.apache.commons.lang.StringUtils;
import org.mule.extension.annotations.capability.Xml;
import org.mule.extension.introspection.capability.XmlCapability;
import org.mule.extension.introspection.declaration.fluent.Declaration;
import org.mule.extension.introspection.declaration.fluent.DeclarationDescriptor;
import org.mule.module.extension.CapabilityExtractor;
import org.mule.module.extension.internal.capability.xml.ImmutableXmlCapability;

public class XmlCapabilityExtractor
implements CapabilityExtractor {
    public static final String DEFAULT_SCHEMA_LOCATION_MASK = "http://www.mulesoft.org/schema/mule/extension/%s";

    public Object extractCapability(DeclarationDescriptor declarationDescriptor, Class<?> capableType) {
        Xml xml = capableType.getAnnotation(Xml.class);
        return xml != null ? this.processCapability(xml, declarationDescriptor) : null;
    }

    private XmlCapability processCapability(Xml xml, DeclarationDescriptor descriptor) {
        Declaration declaration = descriptor.getDeclaration();
        String schemaVersion = StringUtils.isBlank((String)xml.schemaVersion()) ? declaration.getVersion() : xml.schemaVersion();
        String schemaLocation = StringUtils.isBlank((String)xml.schemaLocation()) ? this.buildDefaultLocation(declaration) : xml.schemaLocation();
        return new ImmutableXmlCapability(schemaVersion, xml.namespace(), schemaLocation);
    }

    private String buildDefaultLocation(Declaration declaration) {
        return String.format(DEFAULT_SCHEMA_LOCATION_MASK, declaration.getName());
    }
}

