/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml;

import org.mule.extension.introspection.Capable;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.capability.XmlCapability;
import org.mule.extension.resources.ResourcesGenerator;
import org.mule.extension.resources.spi.GenerableResourceContributor;
import org.mule.module.extension.internal.capability.xml.schema.SchemaGenerator;
import org.mule.module.extension.internal.config.ExtensionsNamespaceHandler;
import org.mule.module.extension.internal.util.CapabilityUtils;

public class SpringBundleResourceContributor
implements GenerableResourceContributor {
    public void contribute(Extension extension, ResourcesGenerator resourcesGenerator) {
        XmlCapability capability = (XmlCapability)CapabilityUtils.getSingleCapability((Capable)extension, XmlCapability.class);
        this.generateSchema(extension, capability, resourcesGenerator);
        this.generateSpringBundle(extension, capability, resourcesGenerator);
    }

    private void generateSchema(Extension extension, XmlCapability capability, ResourcesGenerator resourcesGenerator) {
        String schema = new SchemaGenerator().generate(extension, capability);
        resourcesGenerator.get(this.getXsdFileName(extension)).getContentBuilder().append(schema);
    }

    private void generateSpringBundle(Extension extension, XmlCapability capability, ResourcesGenerator resourcesGenerator) {
        this.writeSpringHandlerBundle(capability, resourcesGenerator);
        this.writeSpringSchemaBundle(extension, capability, resourcesGenerator);
    }

    private void writeSpringHandlerBundle(XmlCapability capability, ResourcesGenerator resourcesGenerator) {
        String content = String.format("%s=%s", capability.getSchemaLocation(), ExtensionsNamespaceHandler.class.getName());
        resourcesGenerator.get("spring.handlers").getContentBuilder().append(this.springBundleScape(content));
    }

    private void writeSpringSchemaBundle(Extension extension, XmlCapability capability, ResourcesGenerator resourcesGenerator) {
        StringBuilder builder = resourcesGenerator.get("spring.schemas").getContentBuilder();
        builder.append(this.getSpringSchemaBundle(extension, capability, capability.getSchemaVersion()));
        builder.append(this.getSpringSchemaBundle(extension, capability, "current"));
    }

    private String getSpringSchemaBundle(Extension extension, XmlCapability capability, String version) {
        String filename = this.getXsdFileName(extension);
        return this.springBundleScape(String.format("%s/%s/%s=META-INF/%s\n", capability.getSchemaLocation(), version, filename, filename));
    }

    private String getXsdFileName(Extension extension) {
        return String.format("mule-%s%s", extension.getName(), ".xsd");
    }

    private String springBundleScape(String content) {
        return content.replaceAll(":", "\\\\:");
    }
}

