/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml.schema;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringUtils;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.capability.XmlCapability;
import org.mule.module.extension.internal.capability.xml.schema.SchemaBuilder;
import org.mule.module.extension.internal.capability.xml.schema.model.NamespaceFilter;
import org.mule.module.extension.internal.capability.xml.schema.model.Schema;
import org.mule.util.Preconditions;
import org.xml.sax.ContentHandler;

public class SchemaGenerator {
    private void validate(Extension extension, XmlCapability xmlCapability) {
        Preconditions.checkArgument((extension != null ? 1 : 0) != 0, (String)"extension cannot be null");
        Preconditions.checkArgument((xmlCapability != null ? 1 : 0) != 0, (String)"capability cannot be null");
        Preconditions.checkState((!StringUtils.isBlank((String)xmlCapability.getNamespace()) ? 1 : 0) != 0, (String)"capability cannot provide a blank namespace");
    }

    public String generate(Extension extension, XmlCapability xmlCapability) {
        this.validate(extension, xmlCapability);
        SchemaBuilder schemaBuilder = SchemaBuilder.newSchema(xmlCapability.getSchemaLocation());
        for (Configuration configuration : extension.getConfigurations()) {
            schemaBuilder.registerConfigElement(configuration);
        }
        for (Operation operation : extension.getOperations()) {
            schemaBuilder.registerOperation(operation);
        }
        schemaBuilder.registerEnums();
        return this.renderSchema(schemaBuilder.build());
    }

    private String renderSchema(Schema schema) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Schema.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            NamespaceFilter outFilter = new NamespaceFilter("mule", "http://www.mulesoft.org/schema/mule/core", true);
            OutputFormat format = new OutputFormat();
            format.setIndent(true);
            format.setNewlines(true);
            StringWriter sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            outFilter.setContentHandler((ContentHandler)writer);
            marshaller.marshal((Object)schema, (ContentHandler)outFilter);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

