/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.HashMap;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.http.api.HttpParameters;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.processor.FetchAccessTokenMessageProcessor;
import org.mule.util.StringUtils;
import org.mule.utils.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2FetchAccessTokenMessageProcessor
extends FetchAccessTokenMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2FetchAccessTokenMessageProcessor.class);
    private OAuth2Manager<OAuth2Adapter> oauthManager;

    public OAuth2FetchAccessTokenMessageProcessor(OAuth2Manager<OAuth2Adapter> oauthManager, String accessTokenId) {
        this.oauthManager = oauthManager;
        this.setAccessTokenId(accessTokenId);
    }

    @Override
    protected MuleEvent doProcess(MuleEvent event) throws Exception {
        MuleEvent restoredEvent = this.restoreOriginalEvent(event);
        this.notifyCallbackReception(event);
        try {
            OAuth2Adapter oauthAdapter = this.oauthManager.createAdapter(restoredEvent, (String)event.getMessage().getInvocationProperty("_oauthVerifier"));
            if (oauthAdapter.getAccessTokenUrl() == null) {
                oauthAdapter.setAccessTokenUrl(this.getAccessTokenUrl());
            }
            oauthAdapter.fetchAccessToken(this.getRedirectUri());
            String transformedAccessTokenId = this.getAccessTokenId();
            if (StringUtils.isEmpty((String)transformedAccessTokenId)) {
                transformedAccessTokenId = this.oauthManager.getDefaultUnauthorizedConnector().getName();
            }
            transformedAccessTokenId = (String)this.evaluateAndTransform(restoredEvent.getMuleContext(), restoredEvent, (Type)((Object)String.class), null, (Object)transformedAccessTokenId);
            this.oauthManager.getAccessTokenPoolFactory().passivateObject((Object)transformedAccessTokenId, (Object)oauthAdapter);
            MuleMessage message = restoredEvent.getMessage();
            message.setInvocationProperty("_oauthVerifier", event.getMessage().getInvocationProperty("_oauthVerifier"));
            message.setInvocationProperty("OAuthAccessTokenId", (Object)transformedAccessTokenId);
            message.removeProperty("http.status", PropertyScope.OUTBOUND);
            message.removeProperty("Location", PropertyScope.OUTBOUND);
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)"Unable to fetch access token"), event, (Throwable)e, (MessageProcessor)this);
        }
        return restoredEvent;
    }

    protected MuleEvent restoreOriginalEvent(MuleEvent event) throws MuleException {
        String state = this.getState(event);
        if (StringUtils.isEmpty((String)state)) {
            return event;
        }
        String eventId = IdUtils.removePadding(this.getEventId(state));
        if (StringUtils.isBlank((String)eventId)) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("Could not fetch original event id for callback with state %s. Will continue with new event without restoring previous one", state));
            }
            return event;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("received callback for event id %s. Fetching original event", eventId));
        }
        MuleEvent restoredEvent = null;
        try {
            restoredEvent = this.oauthManager.restoreAuthorizationEvent(eventId);
        }
        catch (ObjectDoesNotExistException e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)String.format("Could not find authorization event %s in object store", eventId)), event, (Throwable)e, (MessageProcessor)this);
        }
        catch (ObjectStoreException e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)String.format("Error retrieving authorization event %s from object store", eventId)), event, (Throwable)e, (MessageProcessor)this);
        }
        InboundPropertiesDelegate properties = this.getPropertiesDelegate(restoredEvent);
        String cleanedState = this.getOriginalId(state);
        if (cleanedState != null) {
            properties.set("state", cleanedState);
        } else {
            properties.set("state", "");
        }
        RequestContext.setEvent((MuleEvent)restoredEvent);
        return restoredEvent;
    }

    private String getState(MuleEvent event) throws MuleException {
        String state = this.getPropertiesDelegate(event).get("state");
        try {
            return StringUtils.isEmpty((String)state) ? "" : URLDecoder.decode(state, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)("State query param had invalid encoding: " + state)), event, (MessageProcessor)this);
        }
    }

    private InboundPropertiesDelegate getPropertiesDelegate(MuleEvent event) {
        Object parameters = event.getMessage().getInboundProperty("http.query.params");
        return parameters instanceof HttpParameters ? new HttpConnectorDelegate(event) : new OldHttpTransport(event);
    }

    private String getEventId(String state) {
        return state.length() >= 39 ? state.substring(0, 39) : null;
    }

    private String getOriginalId(String state) {
        return state.length() >= 39 ? state.substring(39) : null;
    }

    private class OldHttpTransport
    implements InboundPropertiesDelegate {
        private final MuleEvent event;

        private OldHttpTransport(MuleEvent event) {
            this.event = event;
        }

        @Override
        public String get(String key) {
            return (String)this.event.getMessage().getInboundProperty(key);
        }

        @Override
        public void set(String key, String value) {
            this.event.getMessage().setProperty(key, (Object)value, PropertyScope.INBOUND);
        }
    }

    private class HttpConnectorDelegate
    implements InboundPropertiesDelegate {
        private final HashMap<String, String> parameters;

        private HttpConnectorDelegate(MuleEvent event) {
            this.parameters = new HashMap((HttpParameters)event.getMessage().getInboundProperty("http.query.params"));
            event.getMessage().setProperty("http.query.params", this.parameters, PropertyScope.INBOUND);
        }

        @Override
        public String get(String key) {
            return this.parameters.get(key);
        }

        @Override
        public void set(String key, String value) {
            this.parameters.remove(key);
            this.parameters.put(key, value);
        }
    }

    private static interface InboundPropertiesDelegate {
        public String get(String var1);

        public void set(String var1, String var2);
    }
}

