/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.callback;

import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.security.oauth.callback.HttpCallbackAdapter;
import org.mule.util.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpCallbackAdapter
implements Initialisable,
HttpCallbackAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpCallbackAdapter.class);
    private static final int DEFAULT_LOCAL_PORT = 8080;
    private static final int DEFAULT_REMOTE_PORT = 80;
    private Integer localPort;
    private Integer remotePort;
    private String domain;
    private String path;
    private Object connector;
    private Boolean async = false;

    @Override
    public Integer getLocalPort() {
        return this.localPort;
    }

    @Override
    public void setLocalPort(Integer value) {
        this.localPort = value;
    }

    @Override
    public Integer getRemotePort() {
        return this.remotePort;
    }

    @Override
    public void setRemotePort(Integer value) {
        this.remotePort = value;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String value) {
        this.domain = value;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String value) {
        this.path = value;
    }

    @Override
    public Object getConnector() {
        return this.connector;
    }

    @Override
    public void setConnector(Object value) {
        this.connector = value;
    }

    @Override
    public Boolean getAsync() {
        return this.async;
    }

    @Override
    public void setAsync(Boolean value) {
        this.async = value;
    }

    public void initialise() throws InitialisationException {
        if (this.localPort == null) {
            String portSystemVar = System.getProperty("http.port");
            if (NumberUtils.isDigits((String)portSystemVar)) {
                this.localPort = Integer.parseInt(portSystemVar);
            } else {
                LOGGER.warn("Environment variable 'http.port' not found, using default localPort: 8080");
                this.localPort = 8080;
            }
        }
        if (this.remotePort == null) {
            LOGGER.info("Using default remotePort: 80");
            this.remotePort = 80;
        }
        if (this.domain == null) {
            String domainSystemVar = System.getProperty("fullDomain");
            if (domainSystemVar != null) {
                this.domain = domainSystemVar;
            } else {
                LOGGER.warn("Environment variable 'fullDomain' not found, using default: localhost");
                this.domain = "localhost";
            }
        }
    }
}

