/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import org.apache.commons.lang.StringUtils;
import org.mule.api.MetadataAware;
import org.mule.api.MuleEvent;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OnNoTokenPolicy {
    EXCEPTION{

        @Override
        public MuleEvent handleNotAuthorized(Object source, NotAuthorizedException e, MuleEvent event) throws NotAuthorizedException {
            throw e;
        }
    }
    ,
    STOP_FLOW{

        @Override
        public MuleEvent handleNotAuthorized(Object source, NotAuthorizedException e, MuleEvent event) throws NotAuthorizedException {
            if (logger.isWarnEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Tried to execute OAuth protected operation but the connector was not authorized yet. Stopping execution per OnNoTokenPolicy configuration.");
                if (!StringUtils.isBlank((String)e.getAccessTokenId())) {
                    builder.append(" [accessTokenId = ").append(e.getAccessTokenId()).append("]");
                }
                if (source instanceof MetadataAware) {
                    MetadataAware metadata = (MetadataAware)source;
                    builder.append(" [connector= ").append(metadata.getModuleName());
                } else {
                    builder.append(" [source class= ").append(source.getClass().getCanonicalName());
                }
                logger.warn(builder.toString());
            }
            return null;
        }
    };

    private static final Logger logger;

    public abstract MuleEvent handleNotAuthorized(Object var1, NotAuthorizedException var2, MuleEvent var3) throws NotAuthorizedException;

    static {
        logger = LoggerFactory.getLogger(OnNoTokenPolicy.class);
    }
}

