/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.mule.security.oauth.util.HttpUtil;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtilImpl
implements HttpUtil {
    private static final transient Logger logger = LoggerFactory.getLogger(HttpUtilImpl.class);

    @Override
    public String post(String url, String body) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url + " is not a valid url", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open connection to " + url, e);
        }
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new RuntimeException("Something is wrong with the runtime, POST is not recognized as a verb", e);
        }
        conn.setDoOutput(true);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Sending request to [%s] using the following as content [%s]", url, body));
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(body);
            out.close();
            return IOUtils.toString((InputStream)conn.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Error found while consuming http resource at " + url, e);
        }
    }
}

