/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.common.security.oauth.OAuthState;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOAuthClientFactory
implements KeyedPoolableObjectFactory<String, OAuth2Adapter> {
    private static transient Logger logger = LoggerFactory.getLogger(BaseOAuthClientFactory.class);
    private static transient Map<String, PropertyDescriptor> oauthStateProperties = new HashMap<String, PropertyDescriptor>();
    private OAuth2Manager<OAuth2Adapter> oauthManager;
    private ObjectStore<Serializable> objectStore;

    public BaseOAuthClientFactory(OAuth2Manager<OAuth2Adapter> oauthManager, ObjectStore<Serializable> objectStore) {
        this.oauthManager = oauthManager;
        this.objectStore = objectStore;
    }

    protected abstract Class<? extends OAuth2Adapter> getAdapterClass();

    protected abstract void setCustomAdapterProperties(OAuth2Adapter var1, OAuthState var2);

    protected abstract void setCustomStateProperties(OAuth2Adapter var1, OAuthState var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OAuth2Adapter makeObject(String key) throws Exception {
        OAuthState state = null;
        Lock lock = this.getLock(key);
        lock.lock();
        try {
            if (!this.objectStore.contains((Serializable)((Object)key))) {
                throw new NotAuthorizedException(String.format("There is no access token stored under the key %s . You need to call the <authorize> message processor. The key will be given to you via a flow variable after the OAuth dance is completed. You can extract it using flowVars['tokenId'].", key));
            }
            state = this.retrieveOAuthState(key, true);
        }
        finally {
            lock.unlock();
        }
        OAuth2Adapter connector = this.getAdapterClass().getConstructor(OAuth2Manager.class).newInstance(this.oauthManager);
        connector.setConsumerKey(this.oauthManager.getDefaultUnauthorizedConnector().getConsumerKey());
        connector.setConsumerSecret(this.oauthManager.getDefaultUnauthorizedConnector().getConsumerSecret());
        connector.setAccessToken(state.getAccessToken());
        connector.setAuthorizationUrl(state.getAuthorizationUrl());
        connector.setAccessTokenUrl(state.getAccessTokenUrl());
        connector.setRefreshToken(state.getRefreshToken());
        this.setCustomAdapterProperties(connector, state);
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.oauthManager.getMuleContext());
        }
        if (connector instanceof Initialisable) {
            ((Initialisable)connector).initialise();
        }
        if (connector instanceof Startable) {
            ((Startable)connector).start();
        }
        this.oauthManager.postAuth(connector, key);
        return connector;
    }

    private synchronized OAuthState retrieveOAuthState(String key, boolean replace) {
        Serializable state = null;
        try {
            state = this.objectStore.retrieve((Serializable)((Object)key));
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("Error retrieving value from object store with key " + key, e);
        }
        if (state != null && !(state instanceof OAuthState)) {
            OAuthState newState = new OAuthState();
            try {
                for (PropertyDescriptor beanProperty : Introspector.getBeanInfo(state.getClass(), Object.class).getPropertyDescriptors()) {
                    Object value = beanProperty.getReadMethod().invoke((Object)state, (Object[])null);
                    if (value == null) continue;
                    PropertyDescriptor stateProperty = oauthStateProperties.get(beanProperty.getName());
                    if (stateProperty != null) {
                        stateProperty.getWriteMethod().invoke((Object)newState, value);
                        continue;
                    }
                    newState.setCustomProperty(beanProperty.getName(), value.toString());
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing value through reflection", e);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException("Error introspecting object of class " + state.getClass().getCanonicalName(), e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Error setting value through reflection", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Object threw exception while setting value by reflection", e);
            }
            state = newState;
            if (replace) {
                try {
                    this.objectStore.remove((Serializable)((Object)key));
                    this.objectStore.store((Serializable)((Object)key), (Serializable)newState);
                }
                catch (ObjectStoreException e) {
                    throw new RuntimeException("ObjectStore threw exception while replacing instance", e);
                }
            }
        }
        return (OAuthState)state;
    }

    public final void destroyObject(String key, OAuth2Adapter obj) throws Exception {
        if (!this.getAdapterClass().isInstance(obj)) {
            throw new IllegalArgumentException("Invalid connector type");
        }
        if (obj instanceof Stoppable) {
            ((Stoppable)obj).stop();
        }
        if (obj instanceof Disposable) {
            ((Disposable)obj).dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean validateObject(String key, OAuth2Adapter obj) {
        if (!this.getAdapterClass().isInstance(obj)) {
            throw new IllegalArgumentException("Invalid connector type");
        }
        OAuth2Adapter connector = obj;
        Lock lock = this.getLock(key);
        lock.lock();
        try {
            if (!this.objectStore.contains((Serializable)((Object)key))) {
                boolean bl = false;
                return bl;
            }
            OAuthState state = this.retrieveOAuthState(key, true);
            if (connector.getAccessToken() == null) {
                boolean bl = false;
                return bl;
            }
            if (!connector.getAccessToken().equals(state.getAccessToken())) {
                boolean bl = false;
                return bl;
            }
            if (connector.getRefreshToken() == null && state.getRefreshToken() != null) {
                boolean bl = false;
                return bl;
            }
            if (connector.getRefreshToken() != null && !connector.getRefreshToken().equals(state.getRefreshToken())) {
                boolean bl = false;
                return bl;
            }
        }
        catch (ObjectStoreException e) {
            logger.warn("Could not validate object due to object store exception", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    public void activateObject(String key, OAuth2Adapter obj) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void passivateObject(String key, OAuth2Adapter obj) throws Exception {
        if (!this.getAdapterClass().isInstance(obj)) {
            throw new IllegalArgumentException("Invalid connector type");
        }
        OAuth2Adapter connector = obj;
        OAuthState state = null;
        Lock lock = this.getLock(key);
        lock.lock();
        try {
            if (this.objectStore.contains((Serializable)((Object)key))) {
                state = this.retrieveOAuthState(key, false);
                this.objectStore.remove((Serializable)((Object)key));
            } else {
                state = new OAuthState();
            }
            state.setAccessToken(connector.getAccessToken());
            state.setAccessTokenUrl(connector.getAccessTokenUrl());
            state.setAuthorizationUrl(connector.getAuthorizationUrl());
            state.setRefreshToken(connector.getRefreshToken());
            this.setCustomStateProperties(connector, state);
            this.objectStore.store((Serializable)((Object)key), (Serializable)state);
        }
        finally {
            lock.unlock();
        }
    }

    private Lock getLock(String key) {
        return this.oauthManager.getMuleContext().getLockFactory().createLock(String.format("OAuthTokenKeyLock-%s", key));
    }

    static {
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(OAuthState.class, Object.class).getPropertyDescriptors()) {
                oauthStateProperties.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Error initializing OAuthClientFactory. Could not introspect OAuthState", e);
        }
    }
}

