/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import java.io.IOException;
import org.mule.api.MuleEvent;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.mule.module.db.internal.resolver.query.AbstractBulkQueryResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.module.db.internal.util.FileReader;

public class FileBulkQueryResolver
extends AbstractBulkQueryResolver {
    private final String file;
    private final FileReader fileReader;

    public FileBulkQueryResolver(String file, QueryTemplateParser queryTemplateParser, FileReader fileReader) {
        super(null, queryTemplateParser);
        this.file = file;
        this.fileReader = fileReader;
    }

    @Override
    protected String resolveBulkQueries(MuleEvent muleEvent, String bulkQuery) {
        try {
            return this.fileReader.getResourceAsString(this.file);
        }
        catch (IOException e) {
            throw new QueryResolutionException("Unable to read bulk query file: " + this.file);
        }
    }
}

