/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.el;

import java.sql.SQLException;
import java.util.List;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.util.Preconditions;

public abstract class AbstractDbFunction
implements ExpressionLanguageFunction {
    public static final String INVALID_ARGUMENT_NUMBER = "Function '%s' must receive three parameters, but %s were provided instead";
    public static final String INVALID_DB_CONFIG_ARGUMENT = "Function '%s' must receive a String parameter as the first parameter";
    public static final String INVALID_TYPE_NAME_ARGUMENT = "Function '%s' must receive a String parameter as the second parameter";
    public static final String INVALID_STRUCT_VALUES_ARGUMENT = "Function '%s' must receive a Object[] or List as the third parameter";
    private final MuleContext muleContext;

    protected AbstractDbFunction(MuleContext muleContext) {
        Preconditions.checkArgument((muleContext != null ? 1 : 0) != 0, (String)"muleContext cannot be null");
        this.muleContext = muleContext;
    }

    public Object call(Object[] params, ExpressionLanguageContext context) {
        this.validateParams(params);
        DbConnection connection = null;
        DbConfigResolver dbConfigResolver = (DbConfigResolver)this.muleContext.getRegistry().get((String)params[0]);
        MuleEvent muleEvent = this.getMuleEvent(context);
        DbConfig dbConfig = dbConfigResolver.resolve(muleEvent);
        try {
            connection = dbConfig.getConnectionFactory().createConnection(TransactionalAction.ALWAYS_JOIN);
            String typeName = (String)params[1];
            Object[] structValues = params[2] instanceof List ? ((List)params[2]).toArray() : (Object[])params[2];
            Object object = this.createValue(connection, typeName, structValues);
            return object;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        finally {
            dbConfig.getConnectionFactory().releaseConnection(connection);
        }
    }

    protected abstract Object createValue(DbConnection var1, String var2, Object[] var3) throws SQLException;

    protected abstract String getFunctionName();

    private MuleEvent getMuleEvent(ExpressionLanguageContext context) {
        MuleEvent event = (MuleEvent)context.getVariable("_muleEvent");
        if (event == null) {
            event = RequestContext.getEvent();
        }
        Preconditions.checkState((event != null ? 1 : 0) != 0, (String)"Could not obtain MuleEvent");
        return event;
    }

    private void validateParams(Object[] params) {
        Preconditions.checkArgument((params.length == 3 ? 1 : 0) != 0, (String)this.createInvalidArgumentCountMessage(params.length));
        Preconditions.checkArgument((boolean)(params[0] instanceof String), (String)this.createInvalidDbConfigNameArgument());
        Preconditions.checkArgument((boolean)(params[1] instanceof String), (String)this.createInvalidDbTypeMessage());
        Preconditions.checkArgument((params[2] instanceof Object[] || params[2] instanceof List ? 1 : 0) != 0, (String)this.createInvalidStructValuesArgument());
    }

    final String createInvalidStructValuesArgument() {
        return String.format(INVALID_STRUCT_VALUES_ARGUMENT, this.getFunctionName());
    }

    final String createInvalidDbTypeMessage() {
        return String.format(INVALID_TYPE_NAME_ARGUMENT, this.getFunctionName());
    }

    final String createInvalidDbConfigNameArgument() {
        return String.format(INVALID_DB_CONFIG_ARGUMENT, this.getFunctionName());
    }

    final String createInvalidArgumentCountMessage(int length) {
        return String.format(INVALID_ARGUMENT_NUMBER, this.getFunctionName(), length);
    }
}

