/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.param.AbstractQueryParam;
import org.mule.module.db.internal.domain.param.DefaultInOutQueryParam;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.param.DefaultOutputQueryParam;
import org.mule.module.db.internal.domain.param.InOutQueryParam;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.param.OutputQueryParam;
import org.mule.module.db.internal.domain.param.QueryParam;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DynamicDbType;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.resolver.param.ParamValueResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.module.db.internal.resolver.query.QueryResolver;

public class ParametrizedQueryResolver
implements QueryResolver {
    private final Query query;
    private final ParamValueResolver paramValueResolver;

    public ParametrizedQueryResolver(Query query, ParamValueResolver paramValueResolver) {
        this.query = query;
        this.paramValueResolver = paramValueResolver;
    }

    @Override
    public Query resolve(DbConnection connection, MuleEvent muleEvent) {
        List<QueryParamValue> resolvedParams = this.paramValueResolver.resolveParams(muleEvent, this.query.getParamValues());
        QueryTemplate queryTemplate = this.query.getQueryTemplate();
        if (this.needsParamTypeResolution(queryTemplate.getParams())) {
            Map<Integer, DbType> paramTypes = this.getParameterTypes(connection, queryTemplate);
            queryTemplate = this.resolveQueryTemplate(queryTemplate, paramTypes);
        }
        return new Query(queryTemplate, resolvedParams);
    }

    private Map<Integer, DbType> getParameterTypes(DbConnection connection, QueryTemplate queryTemplate) {
        try {
            return connection.getParamTypes(queryTemplate);
        }
        catch (SQLException e) {
            throw new QueryResolutionException("Cannot resolve parameter types", e);
        }
    }

    private boolean needsParamTypeResolution(List<QueryParam> params) {
        for (QueryParam param : params) {
            if (param.getType() != UnknownDbType.getInstance() && !(param.getType() instanceof DynamicDbType)) continue;
            return true;
        }
        return false;
    }

    private QueryTemplate resolveQueryTemplate(QueryTemplate queryTemplate, Map<Integer, DbType> paramTypes) {
        ArrayList<QueryParam> newParams = new ArrayList<QueryParam>();
        for (QueryParam originalParam : queryTemplate.getParams()) {
            AbstractQueryParam newParam;
            DbType type = paramTypes.get(originalParam.getIndex());
            if (originalParam instanceof InOutQueryParam) {
                newParam = new DefaultInOutQueryParam(originalParam.getIndex(), type, originalParam.getName(), ((InOutQueryParam)originalParam).getValue());
            } else if (originalParam instanceof InputQueryParam) {
                newParam = new DefaultInputQueryParam(originalParam.getIndex(), type, ((InputQueryParam)originalParam).getValue(), originalParam.getName());
            } else if (originalParam instanceof OutputQueryParam) {
                newParam = new DefaultOutputQueryParam(originalParam.getIndex(), type, originalParam.getName());
            } else {
                throw new IllegalArgumentException("Unknown parameter type: " + originalParam.getClass().getName());
            }
            newParams.add(newParam);
        }
        return new QueryTemplate(queryTemplate.getSqlText(), queryTemplate.getType(), newParams);
    }
}

