/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import java.util.Collections;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.module.db.internal.resolver.query.QueryResolver;

public class DynamicQueryResolver
implements QueryResolver {
    private final Query query;
    private final QueryTemplateParser queryTemplateParser;
    private final ExpressionManager expressionManager;

    public DynamicQueryResolver(Query query, QueryTemplateParser queryTemplateParser, ExpressionManager expressionManager) {
        this.query = query;
        this.queryTemplateParser = queryTemplateParser;
        this.expressionManager = expressionManager;
    }

    @Override
    public Query resolve(DbConnection connection, MuleEvent muleEvent) {
        try {
            QueryTemplate queryTemplate = this.query.getQueryTemplate();
            String resolvedSqlText = this.expressionManager.parse(queryTemplate.getSqlText(), muleEvent);
            queryTemplate = this.queryTemplateParser.parse(resolvedSqlText);
            return new Query(queryTemplate, Collections.emptyList());
        }
        catch (RuntimeException e) {
            throw new QueryResolutionException("Error parsing query", e);
        }
    }
}

