/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.MuleEvent;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.module.db.internal.domain.database.DataSourceConfig;
import org.mule.module.db.internal.domain.database.DataSourceFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.database.DbConfigFactory;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.database.UnresolvableDbConfigException;

public class DynamicDbConfigResolver
extends AbstractAnnotatedObject
implements DbConfigResolver {
    public static final String TEST_CONNECTION_ERROR = "Cannot test connection on a dynamic DB config";
    public static final String NO_METADATA_OBTAINED = "No metadata obtained";
    private final String name;
    private final DbConfigFactory dbConfigFactory;
    private final DataSourceConfig dataSourceConfig;
    private final DataSourceFactory dataSourceFactory;
    private final Map<DataSourceConfig, DbConfig> cache = new HashMap<DataSourceConfig, DbConfig>();
    private int instanceCount = 1;

    public DynamicDbConfigResolver(String name, DbConfigFactory dbConfigFactory, DataSourceFactory dataSourceFactory, DataSourceConfig dataSourceConfig) {
        this.name = name;
        this.dbConfigFactory = dbConfigFactory;
        this.dataSourceConfig = dataSourceConfig;
        this.dataSourceFactory = dataSourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbConfig resolve(MuleEvent muleEvent) throws UnresolvableDbConfigException {
        DataSourceConfig resolvedDataSourceConfig = this.dataSourceConfig.resolve(muleEvent);
        DbConfig dbConfig = this.cache.get(resolvedDataSourceConfig);
        if (dbConfig == null) {
            Map<DataSourceConfig, DbConfig> map = this.cache;
            synchronized (map) {
                dbConfig = this.cache.get(resolvedDataSourceConfig);
                if (dbConfig == null) {
                    try {
                        DataSource dynamicDataSource = this.dataSourceFactory.create(resolvedDataSourceConfig);
                        dbConfig = this.dbConfigFactory.create(this.generateDbConfigName(), this.getAnnotations(), dynamicDataSource);
                        dbConfig.setAnnotations(this.getAnnotations());
                        this.cache.put(resolvedDataSourceConfig, dbConfig);
                    }
                    catch (SQLException e) {
                        throw new UnresolvableDbConfigException("Cannot create dynamic dataSource", e);
                    }
                }
            }
        }
        return dbConfig;
    }

    private String generateDbConfigName() {
        return this.name + "-dynamic-" + this.instanceCount++;
    }

    public TestResult test() {
        return new DefaultTestResult(Result.Status.FAILURE, TEST_CONNECTION_ERROR);
    }

    public Result<List<MetaDataKey>> getMetaDataKeys() {
        ArrayList keys = new ArrayList();
        return new DefaultResult(keys, Result.Status.FAILURE, NO_METADATA_OBTAINED);
    }

    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        return new DefaultResult(null, Result.Status.FAILURE, NO_METADATA_OBTAINED);
    }
}

