/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.xa;

import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.module.db.internal.domain.connection.DbPoolingProfile;
import org.mule.module.db.internal.domain.xa.DataSourceDecorator;
import org.mule.module.db.internal.domain.xa.DataSourceWrapper;
import org.mule.util.Preconditions;

public class DefaultDataSourceDecorator
implements DataSourceDecorator {
    private static final Log logger = LogFactory.getLog(DefaultDataSourceDecorator.class);

    @Override
    public DataSource decorate(DataSource dataSource, String dataSourceName, DbPoolingProfile dbPoolingProfile, MuleContext muleContext) {
        Preconditions.checkState((boolean)this.appliesTo(dataSource, muleContext), (String)("DefaultDataSourceDecorator cannot be applied to data source " + dataSource));
        if (dbPoolingProfile != null) {
            logger.warn((Object)"Pooling profile configuration cannot be used with current transaction manager and XADataSource");
        }
        return new DataSourceWrapper((XADataSource)((Object)dataSource));
    }

    @Override
    public boolean appliesTo(DataSource dataSource, MuleContext muleContext) {
        return !this.isDataSourceWrapper(dataSource) && this.isXaDataSource(dataSource);
    }

    private boolean isDataSourceWrapper(DataSource dataSource) {
        return dataSource instanceof DataSourceWrapper;
    }

    private boolean isXaDataSource(DataSource dataSource) {
        return dataSource instanceof XADataSource;
    }
}

