/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type.oracle;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.mule.module.db.internal.domain.type.StructuredDbType;
import org.mule.util.ClassUtils;

public class OracleXmlType
extends StructuredDbType {
    private static final int OPAQUE_TYPE_ID = 2007;
    private static final String XML_TYPE_INTERNAL_NAME = "SYS.XMLTYPE";
    private static final String XML_TYPE_NAME = "XMLTYPE";
    public static final String ORACLE_XMLTYPE_CLASS = "oracle.xdb.XMLType";

    public OracleXmlType() {
        super(2007, XML_TYPE_NAME, XML_TYPE_INTERNAL_NAME);
    }

    @Override
    public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
        return statement.getSQLXML(index);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value) throws SQLException {
        try {
            if (value instanceof String) {
                statement.setObject(index, OracleXmlType.createXmlType(statement.getConnection(), (String)value), 2007);
                return;
            }
            if (value instanceof InputStream) {
                statement.setObject(index, OracleXmlType.createXmlType(statement.getConnection(), (InputStream)value), 2007);
                return;
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        super.setParameterValue(statement, index, value);
    }

    public static Object createXmlType(Connection connection, String xml) throws Exception {
        return OracleXmlType.createXmlType(connection, xml, String.class);
    }

    public static Object createXmlType(Connection connection, InputStream xml) throws Exception {
        return OracleXmlType.createXmlType(connection, xml, InputStream.class);
    }

    private static <T> Object createXmlType(Connection connection, T xmlContent, Class<T> tClass) throws Exception {
        Class<?> xmlTypeClass = OracleXmlType.getXmlTypeClass();
        Constructor<?> xmlTypeConstructor = xmlTypeClass.getConstructor(Connection.class, tClass);
        return xmlTypeConstructor.newInstance(connection, xmlContent);
    }

    public static Class<?> getXmlTypeClass() throws ClassNotFoundException {
        return ClassUtils.getClass((String)ORACLE_XMLTYPE_CLASS);
    }
}

