/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.executor;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.AbstractExecutor;
import org.mule.module.db.internal.domain.executor.QueryExecutor;
import org.mule.module.db.internal.domain.logger.SingleQueryLogger;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.statement.StatementFactory;

public abstract class AbstractSingleQueryExecutor
extends AbstractExecutor
implements QueryExecutor {
    public AbstractSingleQueryExecutor(StatementFactory statementFactory) {
        super(statementFactory);
    }

    @Override
    public Object execute(DbConnection connection, Query query) throws SQLException {
        Statement statement = this.statementFactory.create(connection, query.getQueryTemplate());
        this.prepareQuery(statement, query);
        return this.doExecuteQuery(connection, statement, query);
    }

    @Override
    public Object execute(DbConnection connection, Query query, AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) throws SQLException {
        Statement statement = this.statementFactory.create(connection, query.getQueryTemplate(), autoGeneratedKeyStrategy);
        this.prepareQuery(statement, query);
        return this.doExecuteQuery(connection, statement, query, autoGeneratedKeyStrategy);
    }

    protected abstract Object doExecuteQuery(DbConnection var1, Statement var2, Query var3) throws SQLException;

    protected abstract Object doExecuteQuery(DbConnection var1, Statement var2, Query var3, AutoGeneratedKeyStrategy var4) throws SQLException;

    protected void prepareQuery(Statement statement, Query query) throws SQLException {
        SingleQueryLogger queryLogger = this.queryLoggerFactory.createQueryLogger(this.logger, query.getQueryTemplate());
        if (statement instanceof PreparedStatement) {
            this.doProcessParameters((PreparedStatement)statement, query.getQueryTemplate(), query.getParamValues(), queryLogger);
        }
        queryLogger.logQuery();
    }
}

