/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.database;

import com.mchange.v2.c3p0.DataSources;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import javax.sql.DataSource;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.module.db.internal.domain.connection.DbPoolingProfile;
import org.mule.module.db.internal.domain.database.DataSourceConfig;
import org.mule.module.db.internal.domain.xa.CompositeDataSourceDecorator;
import org.mule.util.concurrent.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory
implements MuleContextAware,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactory.class);
    private final String name;
    private final Set<DataSource> pooledDataSources = new ConcurrentHashSet();
    private final Set<Disposable> disposableDataSources = new ConcurrentHashSet();
    private MuleContext muleContext;

    public DataSourceFactory(String name) {
        this.name = name;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public DataSource create(DataSourceConfig dataSourceConfig) throws SQLException {
        DataSource dataSource = dataSourceConfig.getPoolingProfile() == null ? this.createSingleDataSource(dataSourceConfig) : this.createPooledDataSource(dataSourceConfig);
        if (dataSourceConfig.isUseXaTransactions()) {
            dataSource = this.decorateDataSource(dataSource, dataSourceConfig.getPoolingProfile(), this.getMuleContext());
        }
        if (dataSourceConfig.getPoolingProfile() != null && !dataSourceConfig.isUseXaTransactions()) {
            this.pooledDataSources.add(dataSource);
        } else if (dataSource instanceof Disposable) {
            this.disposableDataSources.add((Disposable)dataSource);
        }
        return dataSource;
    }

    public DataSource decorateDataSource(DataSource dataSource, DbPoolingProfile poolingProfile, MuleContext muleContext) {
        CompositeDataSourceDecorator dataSourceDecorator = new CompositeDataSourceDecorator();
        dataSourceDecorator.init(muleContext);
        return dataSourceDecorator.decorate(dataSource, this.name, poolingProfile, muleContext);
    }

    protected DataSource createSingleDataSource(DataSourceConfig resolvedDataSourceConfig) throws SQLException {
        StandardXADataSource dataSource = resolvedDataSourceConfig.isUseXaTransactions() ? new StandardXADataSource() : new StandardDataSource();
        dataSource.setDriverName(resolvedDataSourceConfig.getDriverClassName());
        if (resolvedDataSourceConfig.getConnectionTimeout() >= 0) {
            dataSource.setLoginTimeout(resolvedDataSourceConfig.getConnectionTimeout());
        }
        dataSource.setPassword(resolvedDataSourceConfig.getPassword());
        dataSource.setTransactionIsolation(resolvedDataSourceConfig.getTransactionIsolation());
        dataSource.setUrl(resolvedDataSourceConfig.getUrl());
        dataSource.setUser(resolvedDataSourceConfig.getUser());
        return dataSource;
    }

    protected DataSource createPooledDataSource(DataSourceConfig dataSourceConfig) throws SQLException {
        if (dataSourceConfig.isUseXaTransactions()) {
            return this.createSingleDataSource(dataSourceConfig);
        }
        return this.createPooledStandardDataSource(this.createSingleDataSource(dataSourceConfig), dataSourceConfig.getPoolingProfile());
    }

    protected DataSource createPooledStandardDataSource(DataSource dataSource, DbPoolingProfile poolingProfile) throws SQLException {
        HashMap<String, Integer> config = new HashMap<String, Integer>();
        config.put("maxPoolSize", poolingProfile.getMaxPoolSize());
        config.put("minPoolSize", poolingProfile.getMinPoolSize());
        config.put("initialPoolSize", poolingProfile.getMinPoolSize());
        config.put("checkoutTimeout", poolingProfile.getMaxWaitMillis());
        config.put("acquireIncrement", poolingProfile.getAcquireIncrement());
        config.put("maxStatements", 0);
        config.put("maxStatementsPerConnection", poolingProfile.getPreparedStatementCacheSize());
        return DataSources.pooledDataSource((DataSource)dataSource, config);
    }

    public void dispose() {
        for (DataSource pooledDataSource : this.pooledDataSources) {
            try {
                DataSources.destroy((DataSource)pooledDataSource);
            }
            catch (SQLException e) {
                logger.warn("Unable to properly release pooled data source", (Throwable)e);
            }
        }
        for (Disposable disposableDataSource : this.disposableDataSources) {
            try {
                disposableDataSource.dispose();
            }
            catch (Exception e) {
                logger.warn("Unable to properly dispose data source", (Throwable)e);
            }
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }
}

