/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection;

import java.sql.Connection;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.module.db.internal.domain.connection.AbstractConnectionFactory;
import org.mule.module.db.internal.domain.connection.ConnectionCreationException;
import org.mule.module.db.internal.domain.connection.ConnectionFactory;

public class RetryConnectionFactory
extends AbstractConnectionFactory {
    private final RetryPolicyTemplate retryPolicyTemplate;
    private final ConnectionFactory delegate;

    public RetryConnectionFactory(RetryPolicyTemplate retryPolicyTemplate, ConnectionFactory delegate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
        this.delegate = delegate;
    }

    @Override
    protected Connection doCreateConnection(final DataSource dataSource) {
        final AtomicReference connectionRef = new AtomicReference();
        try {
            this.retryPolicyTemplate.execute(new RetryCallback(){

                public void doWork(RetryContext context) throws Exception {
                    Connection connection = RetryConnectionFactory.this.delegate.create(dataSource);
                    connectionRef.set(connection);
                }

                public String getWorkDescription() {
                    return "Connection factory";
                }

                public Object getWorkOwner() {
                    return RetryConnectionFactory.this.delegate;
                }
            }, null);
        }
        catch (Exception e) {
            throw new ConnectionCreationException(e);
        }
        return (Connection)connectionRef.get();
    }
}

