/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.processor;

import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.executor.BulkQueryExecutorFactory;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.metadata.QueryMetadataProvider;
import org.mule.module.db.internal.processor.AbstractBulkUpdateMessageProcessor;
import org.mule.module.db.internal.processor.DynamicBulkUpdateMessageProcessor;
import org.mule.module.db.internal.processor.PreparedBulkUpdateMessageProcessor;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.param.DynamicParamValueResolver;
import org.mule.module.db.internal.resolver.query.QueryResolver;
import org.mule.module.db.internal.result.statement.StatementStreamingResultSetCloser;
import org.springframework.beans.factory.FactoryBean;

public class BulkUpdateMessageProcessorFactoryBean
implements FactoryBean<MessageProcessor>,
MuleContextAware {
    private final DbConfigResolver dbConfigResolver;
    private final QueryResolver queryResolver;
    private final BulkQueryExecutorFactory bulkUpdateExecutorFactory;
    private final TransactionalAction transactionalAction;
    private final List<QueryType> validQueryTypes;
    private final Query query;
    private String source;
    private String target;
    private QueryMetadataProvider queryMetadataProvider;
    private AutoGeneratedKeyStrategy autoGeneratedKeyStrategy;
    private StatementStreamingResultSetCloser streamingResultSetCloser;
    private MuleContext muleContext;

    public BulkUpdateMessageProcessorFactoryBean(DbConfigResolver dbConfigResolver, QueryResolver queryResolver, BulkQueryExecutorFactory bulkUpdateExecutorFactory, TransactionalAction transactionalAction, List<QueryType> validQueryTypes, Query query) {
        this.dbConfigResolver = dbConfigResolver;
        this.queryResolver = queryResolver;
        this.bulkUpdateExecutorFactory = bulkUpdateExecutorFactory;
        this.transactionalAction = transactionalAction;
        this.validQueryTypes = validQueryTypes;
        this.query = query;
    }

    public MessageProcessor getObject() throws Exception {
        AbstractBulkUpdateMessageProcessor bulkUpdateMessageProcessor = this.query.isDynamic() ? new DynamicBulkUpdateMessageProcessor(this.dbConfigResolver, this.queryResolver, this.bulkUpdateExecutorFactory, this.transactionalAction, this.validQueryTypes) : new PreparedBulkUpdateMessageProcessor(this.dbConfigResolver, this.queryResolver, this.bulkUpdateExecutorFactory, this.transactionalAction, this.validQueryTypes, new DynamicParamValueResolver(this.muleContext.getExpressionManager()));
        bulkUpdateMessageProcessor.setSource(this.source);
        bulkUpdateMessageProcessor.setTarget(this.target);
        bulkUpdateMessageProcessor.setQueryMetadataProvider(this.queryMetadataProvider);
        bulkUpdateMessageProcessor.setAutoGeneratedKeyStrategy(this.autoGeneratedKeyStrategy);
        bulkUpdateMessageProcessor.setStatementStreamingResultSetCloser(this.streamingResultSetCloser);
        return bulkUpdateMessageProcessor;
    }

    public Class<?> getObjectType() {
        return MessageProcessor.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setQueryMetadataProvider(QueryMetadataProvider queryMetadataProvider) {
        this.queryMetadataProvider = queryMetadataProvider;
    }

    public void setAutoGeneratedKeyStrategy(AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) {
        this.autoGeneratedKeyStrategy = autoGeneratedKeyStrategy;
    }

    public void setStatementStreamingResultSetCloser(StatementStreamingResultSetCloser streamingResultSetCloser) {
        this.streamingResultSetCloser = streamingResultSetCloser;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

