/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.query;

import java.io.IOException;
import org.mule.module.db.internal.util.FileReader;
import org.springframework.beans.factory.FactoryBean;

public class QueryFileFactoryBean
implements FactoryBean<String> {
    private final String fileName;
    private final FileReader fileReader;

    public QueryFileFactoryBean(String fileName, FileReader fileReader) {
        this.fileName = fileName;
        this.fileReader = fileReader;
    }

    public String getObject() throws Exception {
        try {
            return this.fileReader.getResourceAsString(this.fileName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read query from file: " + this.fileName);
        }
    }

    public Class<?> getObjectType() {
        return String.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

