/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.database;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.mule.api.AnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.spring.factories.AnnotatedObjectFactoryBean;
import org.mule.module.db.internal.domain.connection.DbPoolingProfile;
import org.mule.module.db.internal.domain.database.ConfigurableDbConfigFactory;
import org.mule.module.db.internal.domain.database.DataSourceConfig;
import org.mule.module.db.internal.domain.database.DataSourceFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.database.GenericDbConfigFactory;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.database.DynamicDbConfigResolver;
import org.mule.module.db.internal.resolver.database.StaticDbConfigResolver;
import org.mule.util.Preconditions;

public class DbConfigResolverFactoryBean
extends AnnotatedObjectFactoryBean<DbConfigResolver>
implements AnnotatedObject,
MuleContextAware,
Disposable {
    private MuleContext muleContext;
    private String name;
    private DataSource dataSource;
    private Map<String, String> connectionProperties;
    private DataSourceFactory dataSourceFactory;
    private final DataSourceConfig dataSourceConfig = new DataSourceConfig();
    private final ConfigurableDbConfigFactory dbConfigFactory;

    public DbConfigResolverFactoryBean() {
        this(new GenericDbConfigFactory());
    }

    public DbConfigResolverFactoryBean(ConfigurableDbConfigFactory dbConfigFactory) {
        this.dbConfigFactory = dbConfigFactory;
    }

    public Class<?> getObjectType() {
        return DbConfigResolver.class;
    }

    protected DbConfigResolver doCreateInstance() throws Exception {
        this.validate();
        this.dataSourceConfig.setUrl(this.getEffectiveUrl());
        this.dataSourceFactory = this.createDataSourceFactory();
        if (this.dataSourceConfig.isDynamic()) {
            DataSourceFactory dataSourceFactory = new DataSourceFactory(this.name);
            dataSourceFactory.setMuleContext(this.muleContext);
            return new DynamicDbConfigResolver(this.name, this.dbConfigFactory, dataSourceFactory, this.dataSourceConfig);
        }
        DataSource instanceDataSource = this.dataSource == null ? this.dataSourceFactory.create(this.dataSourceConfig) : this.dataSourceFactory.decorateDataSource(this.dataSource, this.dataSourceConfig.getPoolingProfile(), this.muleContext);
        DbConfig dbConfig = this.dbConfigFactory.create(this.name, this.getAnnotations(), instanceDataSource);
        dbConfig.setAnnotations(this.getAnnotations());
        return new StaticDbConfigResolver(dbConfig);
    }

    protected DataSourceFactory createDataSourceFactory() {
        DataSourceFactory dataSourceFactory = new DataSourceFactory(this.name);
        dataSourceFactory.setMuleContext(this.muleContext);
        return dataSourceFactory;
    }

    protected void validate() {
        if (this.dataSource != null) {
            Preconditions.checkState((boolean)this.connectionProperties.isEmpty(), (String)"connection-properties cannot be specified when a DataSource was provided");
        }
    }

    protected String getEffectiveUrl() {
        return this.dataSourceConfig.getUrl();
    }

    public String getUrl() {
        return this.dataSourceConfig.getUrl();
    }

    public void setUrl(String url) {
        this.dataSourceConfig.setUrl(url);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.dataSourceConfig.setTransactionIsolation(transactionIsolation);
    }

    public void setconnectionTimeout(int connectionTimeout) {
        this.dataSourceConfig.setConnectionTimeout(connectionTimeout);
    }

    public void setPassword(String password) {
        this.dataSourceConfig.setPassword(password);
    }

    public void setUser(String user) {
        this.dataSourceConfig.setUser(user);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDriverClassName(String driverClassName) {
        this.dataSourceConfig.setDriverClassName(driverClassName);
    }

    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(Map<String, String> connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.dataSourceConfig.setMuleContext(this.muleContext);
    }

    public void setUseXaTransactions(boolean useXaTransactions) {
        this.dataSourceConfig.setUseXaTransactions(useXaTransactions);
    }

    public void setPoolingProfile(DbPoolingProfile poolingProfile) {
        this.dataSourceConfig.setPoolingProfile(poolingProfile);
    }

    public void setCustomDataTypes(List<DbType> customDataTypes) {
        this.dbConfigFactory.setCustomDataTypes(customDataTypes);
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.dbConfigFactory.setRetryPolicyTemplate(retryPolicyTemplate);
    }

    public void dispose() {
        if (this.dataSourceFactory != null) {
            this.dataSourceFactory.dispose();
        }
    }
}

