/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.result.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.Closeable;
import org.mule.api.MuleException;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.result.resultset.StreamingResultSetCloser;
import org.mule.module.db.internal.result.row.RowHandler;

public class ResultSetIterator
implements Iterator<Map<String, Object>>,
Closeable {
    protected static final Log logger = LogFactory.getLog(ResultSetIterator.class);
    private final ResultSet resultSet;
    private final RowHandler rowHandler;
    private final StreamingResultSetCloser streamingResultSetCloser;
    private DbConnection connection;
    private Boolean cachedNext = null;

    public ResultSetIterator(DbConnection connection, ResultSet resultSet, RowHandler rowHandler, StreamingResultSetCloser streamingResultSetCloser) {
        if (connection == null) {
            throw new NullPointerException();
        }
        this.resultSet = resultSet;
        this.rowHandler = rowHandler;
        this.streamingResultSetCloser = streamingResultSetCloser;
        this.connection = connection;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this.cachedNext == null) {
            block8: {
                try {
                    this.cachedNext = this.resultSet.next();
                    result = this.cachedNext;
                }
                catch (SQLException e) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug((Object)"Unable to determine if there are more records", (Throwable)e);
                }
            }
            if (!result) {
                try {
                    this.close();
                }
                catch (MuleException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Error closing resultset", (Throwable)e);
                    }
                }
            }
        } else {
            result = this.cachedNext;
        }
        return result;
    }

    @Override
    public Map<String, Object> next() {
        try {
            if (this.cachedNext == null) {
                this.resultSet.next();
            } else {
                this.cachedNext = null;
            }
            return this.rowHandler.process(this.resultSet);
        }
        catch (SQLException e) {
            logger.warn((Object)"Unable to obtain next row", (Throwable)e);
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws MuleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Closing resultSet");
        }
        this.streamingResultSetCloser.close(this.connection, this.resultSet);
    }
}

