/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import org.mule.api.MuleEvent;
import org.mule.module.db.internal.domain.query.BulkQuery;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.mule.module.db.internal.resolver.query.BulkQueryResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;

public abstract class AbstractBulkQueryResolver
implements BulkQueryResolver {
    private static final String BULK_QUERY_SEPARATOR = ";[\\r\\n]+";
    protected final String bulkQueryText;
    private final QueryTemplateParser parser;

    public AbstractBulkQueryResolver(String bulkQueryText, QueryTemplateParser queryTemplateParser) {
        this.bulkQueryText = bulkQueryText;
        this.parser = queryTemplateParser;
    }

    @Override
    public BulkQuery resolve(MuleEvent muleEvent) {
        if (muleEvent == null) {
            return null;
        }
        BulkQuery bulkQuery = this.createBulkQuery(muleEvent);
        if (bulkQuery.getQueryTemplates().size() == 0) {
            throw new QueryResolutionException("There are no queries on the resolved dynamic bulk query: " + this.bulkQueryText);
        }
        return bulkQuery;
    }

    protected String resolveBulkQueries(MuleEvent muleEvent, String bulkQuery) {
        return bulkQuery.trim();
    }

    protected BulkQuery createBulkQuery(MuleEvent muleEvent) {
        String[] splitQueries;
        String queries = this.resolveBulkQueries(muleEvent, this.bulkQueryText);
        BulkQuery bulkQuery = new BulkQuery();
        for (String sql : splitQueries = queries.split(BULK_QUERY_SEPARATOR)) {
            if ("".equals(sql.trim())) continue;
            QueryTemplate queryTemplate = this.parser.parse(sql);
            bulkQuery.add(queryTemplate);
        }
        return bulkQuery;
    }
}

