/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.autogeneratedkey;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.QueryTemplate;

public class ColumnIndexAutoGeneratedKeyStrategy
implements AutoGeneratedKeyStrategy {
    private final int[] columnIndexes;

    public ColumnIndexAutoGeneratedKeyStrategy(int[] columnIndexes) {
        this.columnIndexes = columnIndexes;
    }

    @Override
    public boolean returnsAutoGeneratedKeys() {
        return true;
    }

    @Override
    public PreparedStatement prepareStatement(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
        return connection.prepareStatement(queryTemplate.getSqlText(), this.columnIndexes);
    }

    @Override
    public boolean execute(Statement statement, QueryTemplate queryTemplate) throws SQLException {
        if (statement instanceof PreparedStatement) {
            return ((PreparedStatement)statement).execute();
        }
        return statement.execute(queryTemplate.getSqlText(), this.columnIndexes);
    }

    @Override
    public int executeUpdate(Statement statement, QueryTemplate queryTemplate) throws SQLException {
        if (statement instanceof PreparedStatement) {
            return ((PreparedStatement)statement).executeUpdate();
        }
        return statement.executeUpdate(queryTemplate.getSqlText(), this.columnIndexes);
    }
}

