/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.query;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.param.QueryParam;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class QueryTemplateFactoryBean
extends AbstractFactoryBean<QueryTemplate> {
    private final QueryTemplate queryTemplate;
    private final List<QueryParamValue> params;

    public QueryTemplateFactoryBean(QueryTemplate queryTemplate, List<QueryParamValue> params) {
        this.queryTemplate = queryTemplate;
        this.params = params != null ? params : Collections.emptyList();
    }

    public Class<?> getObjectType() {
        return QueryTemplate.class;
    }

    protected QueryTemplate createInstance() throws Exception {
        if (this.params.isEmpty()) {
            return this.queryTemplate;
        }
        LinkedList<QueryParam> paramDefinitions = new LinkedList<QueryParam>();
        boolean usesNameParamOverride = this.usesNamedParamOverride();
        if (usesNameParamOverride) {
            this.processNameParamOverride(paramDefinitions);
        }
        return new QueryTemplate(this.queryTemplate.getSqlText(), this.queryTemplate.getType(), paramDefinitions);
    }

    private void processNameParamOverride(List<QueryParam> paramDefinitions) {
        for (InputQueryParam param : this.queryTemplate.getInputParams()) {
            QueryParamValue queryParamValue = this.getOverriddenParam(param.getName());
            Object value = queryParamValue != null ? queryParamValue.getValue() : param.getValue();
            DefaultInputQueryParam newParam = new DefaultInputQueryParam(param.getIndex(), param.getType(), value, param.getName());
            paramDefinitions.add(newParam);
        }
    }

    private QueryParamValue getOverriddenParam(String name) {
        for (QueryParamValue param : this.params) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }

    private boolean usesNamedParamOverride() {
        boolean result = false;
        for (QueryParamValue param : this.params) {
            if (param.getName() == null || "".equals(param.getName())) continue;
            result = true;
            break;
        }
        return result;
    }
}

