/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.query;

import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.module.db.internal.parser.SimpleQueryTemplateParser;
import org.mule.module.db.internal.resolver.param.ParamValueResolver;
import org.mule.module.db.internal.resolver.query.BulkQueryResolver;
import org.mule.module.db.internal.resolver.query.DynamicBulkQueryResolver;
import org.mule.module.db.internal.resolver.query.StaticBulkQueryResolver;
import org.springframework.beans.factory.FactoryBean;

public class BulkQueryResolverFactoryBean
implements FactoryBean<BulkQueryResolver>,
MuleContextAware {
    private final String bulkQuery;
    private MuleContext context;

    public BulkQueryResolverFactoryBean(String bulkQuery) {
        this.bulkQuery = bulkQuery;
    }

    public BulkQueryResolver getObject() throws Exception {
        if (this.context.getExpressionManager().isExpression(this.bulkQuery)) {
            return new DynamicBulkQueryResolver(this.bulkQuery, new SimpleQueryTemplateParser(), this.context.getExpressionManager());
        }
        return new StaticBulkQueryResolver(this.bulkQuery, new SimpleQueryTemplateParser());
    }

    public Class<?> getObjectType() {
        return ParamValueResolver.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setMuleContext(MuleContext context) {
        this.context = context;
    }
}

