/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.resolver;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.module.db.resolver.SqlCommandResolutionException;
import org.mule.module.db.resolver.SqlCommandResolver;
import org.mule.module.db.resolver.SqlParamResolver;
import org.mule.module.db.sqlexecutor.command.InputSqlParamValue;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.connection.DbConfig;
import org.mule.module.db.sqlexecutor.connection.DbConfigResolver;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.param.AbstractSqlParam;
import org.mule.module.db.sqlexecutor.param.DefaultInOutSqlParam;
import org.mule.module.db.sqlexecutor.param.DefaultInputSqlParam;
import org.mule.module.db.sqlexecutor.param.DefaultOutputSqlParam;
import org.mule.module.db.sqlexecutor.param.InOutSqlParam;
import org.mule.module.db.sqlexecutor.param.InputSqlParam;
import org.mule.module.db.sqlexecutor.param.OutputSqlParam;
import org.mule.module.db.sqlexecutor.param.SqlParam;
import org.mule.module.db.sqlexecutor.parser.SimpleSqlCommandParser;
import org.mule.module.db.sqlexecutor.type.DbType;
import org.mule.module.db.transaction.TransactionalAction;

public abstract class AbstractSqlCommandResolver
implements SqlCommandResolver {
    private final SqlParamResolver sqlParamResolver;
    private DbConfigResolver dbConfigResolver;

    public AbstractSqlCommandResolver(SqlParamResolver sqlParamResolver, DbConfigResolver dbConfigResolver) {
        this.sqlParamResolver = sqlParamResolver;
        this.dbConfigResolver = dbConfigResolver;
    }

    protected SqlCommand resolveSqlCommand(MuleEvent muleEvent, SqlCommand sqlCommand) {
        if (muleEvent == null) {
            return sqlCommand;
        }
        SqlCommand resolvedSqlCommand = sqlCommand;
        if (this.isDynamic(sqlCommand)) {
            SqlCommandDefinition sqlCommandDefinition = sqlCommand.getSqlCommandDefinition();
            ExpressionManager expressionManager = muleEvent.getMuleContext().getExpressionManager();
            String resolvedSqlText = expressionManager.parse(sqlCommandDefinition.getSqlText(), muleEvent);
            SimpleSqlCommandParser sqlParser = new SimpleSqlCommandParser();
            sqlCommandDefinition = sqlParser.parse(resolvedSqlText);
            resolvedSqlCommand = new SqlCommand(sqlCommandDefinition, Collections.EMPTY_LIST);
        } else if (this.hasParameters(sqlCommand)) {
            List<InputSqlParamValue> resolvedParams = this.sqlParamResolver.resolveParams(muleEvent, sqlCommand.getParamValues());
            SqlCommandDefinition sqlCommandDefinition = sqlCommand.getSqlCommandDefinition().getType() == SqlCommandType.STORE_PROCEDURE_CALL ? this.resolveStoredProcedureDefinition(muleEvent, sqlCommand) : sqlCommand.getSqlCommandDefinition();
            resolvedSqlCommand = new SqlCommand(sqlCommandDefinition, resolvedParams);
        }
        return resolvedSqlCommand;
    }

    private SqlCommandDefinition resolveStoredProcedureDefinition(MuleEvent muleEvent, SqlCommand sqlCommand) {
        SqlCommandDefinition originalCommandDefinition = sqlCommand.getSqlCommandDefinition();
        DbConfig config = this.dbConfigResolver.resolve(muleEvent);
        Map<Integer, DbType> paramTypes = this.getStoreProcedureParameterTypes(originalCommandDefinition, config);
        return this.resolveSqlCommandDefinition(originalCommandDefinition, paramTypes);
    }

    private Map<Integer, DbType> getStoreProcedureParameterTypes(SqlCommandDefinition originalCommandDefinition, DbConfig config) {
        DbConnection connection = null;
        try {
            connection = config.getConnectionFactory().createConnection(TransactionalAction.JOIN_IF_POSSIBLE);
            Map<Integer, DbType> map = config.getDbTypeResolver().getParameterTypes(connection, originalCommandDefinition);
            return map;
        }
        catch (SQLException e) {
            throw new SqlCommandResolutionException("Unable to resolve command", e);
        }
        finally {
            if (connection != null) {
                config.getConnectionFactory().releaseConnection(connection);
            }
        }
    }

    private SqlCommandDefinition resolveSqlCommandDefinition(SqlCommandDefinition originalCommandDefinition, Map<Integer, DbType> paramTypes) {
        ArrayList<SqlParam> newParams = new ArrayList<SqlParam>();
        for (SqlParam originalParam : originalCommandDefinition.getParams()) {
            AbstractSqlParam newParam;
            DbType type = paramTypes.get(originalParam.getIndex());
            if (originalParam instanceof InOutSqlParam) {
                newParam = new DefaultInOutSqlParam(originalParam.getIndex(), type, originalParam.getName(), ((InOutSqlParam)originalParam).getValue());
            } else if (originalParam instanceof InputSqlParam) {
                newParam = new DefaultInputSqlParam(originalParam.getIndex(), type, ((InputSqlParam)originalParam).getValue(), originalParam.getName());
            } else if (originalParam instanceof OutputSqlParam) {
                newParam = new DefaultOutputSqlParam(originalParam.getIndex(), type, originalParam.getName());
            } else {
                throw new IllegalArgumentException("Unknown parameter type: " + originalParam.getClass().getName());
            }
            newParams.add(newParam);
        }
        return new SqlCommandDefinition(originalCommandDefinition.getSqlText(), originalCommandDefinition.getType(), newParams);
    }

    protected boolean requiresSqlResolution(SqlCommand sqlCommand) {
        return this.hasParameters(sqlCommand) || this.isDynamic(sqlCommand);
    }

    private boolean isDynamic(SqlCommand sqlCommand) {
        return sqlCommand.getSqlCommandDefinition().isDynamic();
    }

    private boolean hasParameters(SqlCommand sqlCommand) {
        return sqlCommand.getSqlCommandDefinition().getParams().size() > 0;
    }
}

