/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.processor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mule.module.db.processor.AbstractSingleCommandDbMessageProcessor;
import org.mule.module.db.resolver.SqlCommandResolver;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.connection.DbConfigResolver;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.CommandExecutorFactory;
import org.mule.module.db.transaction.TransactionalAction;

public class QueryMessageProcessor
extends AbstractSingleCommandDbMessageProcessor {
    private CommandExecutorFactory commandExecutorFactory;
    private boolean streaming;
    private final List<SqlCommandType> validSqlCommandTypes;

    public QueryMessageProcessor(DbConfigResolver dbConfigResolver, SqlCommandResolver sqlCommandResolver, CommandExecutorFactory commandExecutorFactory, TransactionalAction transactionalAction, boolean streaming) {
        super(dbConfigResolver, sqlCommandResolver, transactionalAction);
        this.commandExecutorFactory = commandExecutorFactory;
        this.streaming = streaming;
        this.validSqlCommandTypes = new ArrayList<SqlCommandType>();
        this.validSqlCommandTypes.add(SqlCommandType.QUERY);
        this.validSqlCommandTypes.add(SqlCommandType.STORE_PROCEDURE_CALL);
    }

    @Override
    protected boolean mustCloseConnection() {
        return !this.streaming;
    }

    @Override
    protected List<SqlCommandType> getValidSqlCommandTypes() {
        return this.validSqlCommandTypes;
    }

    @Override
    protected Object doExecuteSqlCommand(DbConnection connection, SqlCommand sqlCommand) throws SQLException {
        Object commandExecutor = this.commandExecutorFactory.create(connection);
        return commandExecutor.execute(connection, sqlCommand);
    }
}

