/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.resulthandler;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.Closeable;
import org.mule.api.MuleException;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.param.OutputSqlParam;
import org.mule.module.db.sqlexecutor.resulthandler.GeneratedKeysProcessingException;
import org.mule.module.db.sqlexecutor.resulthandler.OutputParamProcessingException;
import org.mule.module.db.sqlexecutor.resulthandler.OutputParamResult;
import org.mule.module.db.sqlexecutor.resulthandler.ResultSetHandler;
import org.mule.module.db.sqlexecutor.resulthandler.ResultSetProcessingException;
import org.mule.module.db.sqlexecutor.resulthandler.ResultSetResult;
import org.mule.module.db.sqlexecutor.resulthandler.StatementResult;
import org.mule.module.db.sqlexecutor.resulthandler.UpdateCountResult;

public class StatementResultIterator
implements Iterator<StatementResult>,
Closeable {
    public static final int NO_UPDATE_COUNT = -1;
    private final Log logger = LogFactory.getLog(StatementResultIterator.class);
    private final Statement statement;
    private final SqlCommandDefinition sqlCommandDefinition;
    private final AutoGeneratedKey autoGeneratedKey;
    private final DbConnection connection;
    private final ResultSetHandler resultSetHandler;
    private final int outputParamsSize;
    private Boolean cachedResult = null;
    private ResultSet resultSet;
    private int updateCount;
    private int currentOutputParam;
    private int updateCountIndex = 1;
    private int resultSetIndex = 1;
    private boolean isFirstInvocation = true;
    private ResultSet generatedKeys;
    private boolean processedGeneratedKeyResultSet;

    public StatementResultIterator(DbConnection connection, Statement statement, SqlCommandDefinition sqlCommandDefinition, AutoGeneratedKey autoGeneratedKey, ResultSetHandler resultSetHandler) {
        this.statement = statement;
        this.sqlCommandDefinition = sqlCommandDefinition;
        this.autoGeneratedKey = autoGeneratedKey;
        this.connection = connection;
        this.resultSetHandler = resultSetHandler;
        this.outputParamsSize = sqlCommandDefinition.getOutputParams().size();
        this.currentOutputParam = 0;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.doHasNext();
        if (!hasNext) {
            try {
                this.close();
            }
            catch (MuleException muleException) {
                // empty catch block
            }
        }
        return hasNext;
    }

    private boolean doHasNext() {
        if (this.cachedResult != null) {
            return this.cachedResult;
        }
        try {
            if (!this.isFirstInvocation) {
                if (!this.processedGeneratedKeyResultSet) {
                    if (this.retrieveAutoGeneratedKeys()) {
                        this.generatedKeys = this.statement.getGeneratedKeys();
                        this.processedGeneratedKeyResultSet = true;
                    } else {
                        this.processedGeneratedKeyResultSet = true;
                    }
                }
                if (this.generatedKeys == null) {
                    this.moveToNextResult();
                }
            } else {
                this.isFirstInvocation = false;
            }
            if (this.generatedKeys != null) {
                this.cachedResult = true;
                return true;
            }
            this.resultSet = this.statement.getResultSet();
            if (this.resultSet != null) {
                this.cachedResult = true;
                return true;
            }
            this.updateCount = this.statement.getUpdateCount();
            if (this.updateCount != -1) {
                this.cachedResult = true;
                return true;
            }
            this.cachedResult = this.currentOutputParam < this.outputParamsSize;
            return this.cachedResult;
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Unable to determine if there are more statement results", (Throwable)e);
            return false;
        }
    }

    protected boolean retrieveAutoGeneratedKeys() {
        return this.autoGeneratedKey.retrieveAutoGeneratedKeys();
    }

    @Override
    public StatementResult next() {
        StatementResult result;
        if (this.cachedResult == null) {
            this.hasNext();
        }
        this.cachedResult = null;
        if (this.resultSet != null) {
            result = this.processResultSet();
            this.resultSet = null;
        } else if (this.updateCount != -1) {
            result = this.doProcessUpdateCount("updateCount" + this.updateCountIndex++, this.updateCount);
            this.updateCount = -1;
        } else if (this.generatedKeys != null) {
            result = this.processGeneratedKeys();
            this.generatedKeys = null;
        } else if (this.currentOutputParam < this.outputParamsSize) {
            result = this.processOutputParam();
            ++this.currentOutputParam;
        } else {
            throw new NoSuchElementException();
        }
        return result;
    }

    private StatementResult processGeneratedKeys() {
        StatementResult generatedKeysResult;
        try {
            generatedKeysResult = this.doProcessResultSet("generatedKeys", this.generatedKeys);
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Unable to obtain auto generated keys", (Throwable)e);
            throw new GeneratedKeysProcessingException(e);
        }
        return generatedKeysResult;
    }

    private void moveToNextResult() {
        try {
            this.statement.getMoreResults();
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Error obtaining next statement result", (Throwable)e);
        }
    }

    protected StatementResult processOutputParam() {
        OutputSqlParam outputSqlParam = this.sqlCommandDefinition.getOutputParams().get(this.currentOutputParam);
        try {
            Object paramValue = ((CallableStatement)this.statement).getObject(outputSqlParam.getIndex());
            return this.doProcessOutputParam(outputSqlParam, paramValue);
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Unable to obtain output parameter", (Throwable)e);
            throw new OutputParamProcessingException(e);
        }
    }

    protected StatementResult doProcessOutputParam(OutputSqlParam outputSqlParam, Object paramValue) {
        return new OutputParamResult(outputSqlParam.getName(), paramValue);
    }

    protected StatementResult doProcessUpdateCount(String name, int value) {
        return new UpdateCountResult(name, value);
    }

    private StatementResult processResultSet() {
        StatementResult result;
        String name = "resultSet" + this.resultSetIndex++;
        try {
            result = this.doProcessResultSet(name, this.resultSet);
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Unable to obtain next resultSet", (Throwable)e);
            throw new ResultSetProcessingException("Error processing result set: " + name, e);
        }
        return result;
    }

    protected StatementResult doProcessResultSet(String name, ResultSet resultSet) throws SQLException {
        Object handledResultSet = this.resultSetHandler.processResultSet(this.connection, resultSet);
        return new ResultSetResult(name, handledResultSet);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws MuleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Releasing connection from statement result iterator");
        }
        this.connection.release();
    }
}

