/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.processor;

import java.sql.SQLException;
import java.util.List;
import org.mule.module.db.processor.AbstractSingleCommandDbMessageProcessor;
import org.mule.module.db.resolver.SqlCommandResolver;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.connection.DbConfigResolver;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.CommandExecutorFactory;
import org.mule.module.db.transaction.TransactionalAction;

public class UpdateMessageProcessor
extends AbstractSingleCommandDbMessageProcessor {
    private AutoGeneratedKey autoGeneratedKey;
    private final CommandExecutorFactory commandExecutorFactory;
    private List<SqlCommandType> validSqlCommandTypes;

    public UpdateMessageProcessor(DbConfigResolver dbConfigResolver, SqlCommandResolver sqlCommandResolver, CommandExecutorFactory commandExecutorFactory, TransactionalAction transactionalAction, List<SqlCommandType> validSqlCommandTypes) {
        super(dbConfigResolver, sqlCommandResolver, transactionalAction);
        this.commandExecutorFactory = commandExecutorFactory;
        this.validSqlCommandTypes = validSqlCommandTypes;
    }

    @Override
    protected List<SqlCommandType> getValidSqlCommandTypes() {
        return this.validSqlCommandTypes;
    }

    @Override
    protected Object doExecuteSqlCommand(DbConnection connection, SqlCommand sqlCommand) throws SQLException {
        Object commandExecutor = this.commandExecutorFactory.create(connection);
        return commandExecutor.execute(connection, sqlCommand, this.autoGeneratedKey);
    }

    public AutoGeneratedKey getAutoGeneratedKey() {
        return this.autoGeneratedKey;
    }

    public void setAutoGeneratedKey(AutoGeneratedKey autoGeneratedKey) {
        this.autoGeneratedKey = autoGeneratedKey;
    }
}

