/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.mule.RequestContext;
import org.mule.api.security.Authentication;
import org.mule.api.security.Credentials;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityManager;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.security.DefaultMuleAuthentication;
import org.mule.security.MuleCredentials;

public class MuleSecurityManagerValidator
implements Validator {
    private static Log logger = LogFactory.getLog(MuleSecurityManagerValidator.class);
    private SecurityManager securityManager;

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getUsernametoken() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        DefaultMuleAuthentication auth = new DefaultMuleAuthentication((Credentials)new MuleCredentials(credential.getUsernametoken().getName(), credential.getUsernametoken().getPassword().toCharArray()));
        try {
            Authentication authentication = this.securityManager.authenticate((Authentication)auth);
            SecurityContext secContext = null;
            try {
                secContext = this.securityManager.createSecurityContext(authentication);
                secContext.setAuthentication(authentication);
            }
            catch (UnknownAuthenticationTypeException e) {
                logger.warn((Object)"Could not create security context after having successfully authenticated.", (Throwable)e);
            }
            RequestContext.getEvent().getSession().setSecurityContext(secContext);
        }
        catch (SecurityException e) {
            throw new WSSecurityException(5, null, null, (Throwable)e);
        }
        catch (SecurityProviderNotFoundException e) {
            throw new WSSecurityException(5, null, null, (Throwable)e);
        }
        return credential;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }
}

